/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.crane.core.helper.BaseTableMap;
import top.xiajibagao.crane.core.helper.BeanProperty;
import top.xiajibagao.crane.core.helper.TableMap;

public class ReflexUtils {
    private static final TableMap<Class<?>, String, BeanProperty> CACHE_TABLE = new BaseTableMap();
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    private ReflexUtils() {
    }

    @Nullable
    public static Method findMethod(Class<?> targetClass, String methodName, boolean allowSubclasses, Class<?> returnType, Class<?> ... paramTypes) {
        return ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> {
            boolean returnTypeMatched;
            if (!Objects.equals(method.getName(), methodName)) {
                return false;
            }
            boolean bl = returnTypeMatched = allowSubclasses ? ClassUtils.isAssignable((Class)returnType, method.getReturnType()) : Objects.equals(returnType, method.getReturnType());
            if (!returnTypeMatched) {
                return false;
            }
            if (ArrayUtil.isNotEmpty((Object[])paramTypes)) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (paramTypes.length != parameterTypes.length) {
                    return false;
                }
                for (int i = 0; i < parameterTypes.length; ++i) {
                    boolean paramTypeMatched;
                    boolean bl2 = paramTypeMatched = allowSubclasses ? ClassUtils.isAssignable((Class)paramTypes[i], parameterTypes[i]) : Objects.equals(paramTypes[i], parameterTypes[i]);
                    if (paramTypeMatched) continue;
                    return false;
                }
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<BeanProperty> findProperty(Class<?> targetClass, String fieldName) {
        BeanProperty property = CACHE_TABLE.getVal(targetClass, fieldName);
        if (!Objects.isNull(property)) return Optional.ofNullable(property);
        Class<ReflexUtils> clazz = ReflexUtils.class;
        synchronized (ReflexUtils.class) {
            property = CACHE_TABLE.getVal(targetClass, fieldName);
            if (!Objects.isNull(property)) return Optional.ofNullable(property);
            property = ReflexUtils.createProperty(targetClass, fieldName);
            CACHE_TABLE.putVal(targetClass, fieldName, property);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Optional.ofNullable(property);
        }
    }

    @Nullable
    private static BeanProperty createProperty(Class<?> targetClass, String fieldName) {
        Field field = ReflexUtils.findField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return null;
        }
        Method getter = ReflexUtils.findGetterMethod(targetClass, field);
        Assert.notNull((Object)getter, (String)String.format("\u5c5e\u6027[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Getter\u65b9\u6cd5", field));
        Method setter = ReflexUtils.findSetterMethod(targetClass, field);
        Assert.notNull((Object)setter, (String)String.format("\u5c5e\u6027[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Setter\u65b9\u6cd5", field));
        return new BeanProperty(targetClass, field, getter, setter);
    }

    @Nullable
    public static Field findField(Class<?> targetClass, String fieldName) {
        return ReflectionUtils.findField(targetClass, (String)fieldName);
    }

    @Nullable
    public static Method findSetterMethod(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        String standardMethodName = ReflexUtils.getStandardMethodName(SET_PREFIX, fieldName);
        Method getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), standardMethodName) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable((Class)fieldType, method.getParameterTypes()[0]));
        if (Objects.nonNull(getter)) {
            return getter;
        }
        return ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), fieldName) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable((Class)fieldType, method.getParameterTypes()[0]));
    }

    @Nullable
    public static Method findSetterMethod(Class<?> targetClass, Field field) {
        return ReflexUtils.findSetterMethod(targetClass, field.getName(), field.getType());
    }

    @Nullable
    public static Method findGetterMethod(Class<?> targetClass, String fieldName) {
        Method getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), ReflexUtils.getStandardMethodName(GET_PREFIX, fieldName)) && method.getParameterTypes().length == 0);
        if (Objects.nonNull(getter)) {
            return getter;
        }
        getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), ReflexUtils.getStandardMethodName(IS_PREFIX, fieldName)) && method.getParameterTypes().length == 0);
        return Objects.nonNull(getter) ? getter : ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), fieldName) && method.getParameterTypes().length == 0);
    }

    @Nullable
    public static Method findGetterMethod(Class<?> targetClass, Field field) {
        return ReflexUtils.findGetterMethod(targetClass, field.getName());
    }

    public static <T> void forEachFromClass(Class<?> targetClass, Function<Class<?>, T[]> targetMapping, Consumer<T> consumer) {
        while (!Objects.equals(targetClass, Object.class) && Objects.nonNull(targetClass)) {
            T[] targets;
            for (T t : targets = targetMapping.apply(targetClass)) {
                consumer.accept(t);
            }
            targetClass = targetClass.getSuperclass();
        }
    }

    public static <T> T findFromClass(Class<?> targetClass, Function<Class<?>, T[]> targetMapping, Predicate<T> predicate) {
        while (!Objects.equals(targetClass, Object.class) && Objects.nonNull(targetClass)) {
            T[] targets;
            for (T t : targets = targetMapping.apply(targetClass)) {
                if (!predicate.test(t)) continue;
                return t;
            }
            targetClass = targetClass.getSuperclass();
        }
        return null;
    }

    private static String getStandardMethodName(String prefix, String name) {
        return CharSequenceUtil.upperFirstAndAddPre((CharSequence)name, (String)prefix);
    }
}

