/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.operator;

import cn.hutool.core.collection.CollUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.operator.interfaces.Assembler;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.EmptyAssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;

public class BeanReflexAssembler
implements Assembler {
    private final OperateHandlerChain handlerChain;

    @Override
    public void execute(Object target, Object source, AssembleOperation operation) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        List properties = (List)CollUtil.defaultIfEmpty(operation.getProperties(), Collections.singletonList(EmptyAssembleProperty.instance()));
        for (AssembleProperty property : properties) {
            Object sourceData = this.handlerChain.readFromSource(source, property, operation);
            if (Objects.isNull(sourceData)) {
                return;
            }
            this.handlerChain.writeToTarget(sourceData, target, property, operation);
        }
    }

    @Override
    public Object getKey(Object target, AssembleOperation operation) {
        return this.handlerChain.readFromSource(target, new BeanAssembleProperty(null, operation.getTargetProperty().getName(), "", Void.class), operation);
    }

    public OperateHandlerChain getHandlerChain() {
        return this.handlerChain;
    }

    public BeanReflexAssembler(OperateHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }
}

