/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.annotation.Assemble;
import top.xiajibagao.crane.core.annotation.Disassemble;
import top.xiajibagao.crane.core.annotation.PropsTemplate;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.BeanAssembleOperation;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.BeanDisassembleOperation;
import top.xiajibagao.crane.core.parser.BeanOperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class BeanOperateConfigurationParser
implements OperateConfigurationParser<BeanOperationConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BeanOperateConfigurationParser.class);
    private final GlobalConfiguration configuration;
    private final BeanFactory beanFactory;

    @Override
    public BeanOperationConfiguration parse(Class<?> targetClass, OperatorFactory operatorFactory) {
        return this.parse(targetClass, operatorFactory, new ParseContext());
    }

    private BeanOperationConfiguration parse(Class<?> targetClass, OperatorFactory operatorFactory, ParseContext parseContext) {
        BeanOperationConfiguration operationConfiguration = this.createConfiguration(targetClass, operatorFactory);
        ArrayList<AssembleOperation> sortedAssembleOperations = new ArrayList<AssembleOperation>();
        ArrayList<DisassembleOperation> sortedDisassembleOperations = new ArrayList<DisassembleOperation>();
        for (Field field : targetClass.getDeclaredFields()) {
            sortedAssembleOperations.addAll(this.parseAssemblerAnnotation(field, operationConfiguration));
            sortedDisassembleOperations.addAll(this.parseDisassembleAnnotation(field, operationConfiguration, parseContext));
        }
        Collections.sort(sortedAssembleOperations);
        operationConfiguration.getAssembleOperations().addAll(sortedAssembleOperations);
        Collections.sort(sortedDisassembleOperations);
        operationConfiguration.getDisassembleOperations().addAll(sortedDisassembleOperations);
        return operationConfiguration;
    }

    protected BeanOperationConfiguration createConfiguration(Class<?> targetClass, OperatorFactory operatorFactory) {
        return new BeanOperationConfiguration(this.configuration, targetClass, operatorFactory, new ArrayList<AssembleOperation>(), new ArrayList<DisassembleOperation>());
    }

    protected List<AssembleOperation> parseAssemblerAnnotation(Field property, BeanOperationConfiguration configuration) {
        Assemble assemble = (Assemble)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)property, Assemble.class);
        List operations = ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)property, Assemble.List.class), list -> CollStreamUtil.toList(Arrays.asList(list.value()), a -> this.createAssembleOperation(property, (Assemble)a, configuration)), new ArrayList());
        if (Objects.nonNull(assemble)) {
            operations.add(this.createAssembleOperation(property, assemble, configuration));
        }
        CraneException.throwIfFalse(CollectionUtils.isEmpty((Collection)operations) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)property, Disassemble.class), "[{}]\u5c5e\u6027[{}]\u65e0\u6cd5\u540c\u65f6\u88ab{}\u548c{}\u6ce8\u89e3\u6807\u8bb0", configuration.getTargetClass(), property, Assemble.class, Disassemble.class);
        return operations;
    }

    protected AssembleOperation createAssembleOperation(Field property, Assemble annotation, BeanOperationConfiguration configuration) {
        Set<String> aliases = CollUtils.toSet(Arrays.asList(annotation.aliases()));
        Container container = CharSequenceUtil.isNotBlank((CharSequence)annotation.containerName()) ? (ClassUtils.isAssignable(Container.class, annotation.container()) ? (Container)this.beanFactory.getBean(annotation.containerName(), annotation.container()) : (Container)this.beanFactory.getBean(annotation.containerName())) : (Container)this.beanFactory.getBean(annotation.container());
        ArrayList<AssembleProperty> properties = new ArrayList<AssembleProperty>(CollStreamUtil.toList(Arrays.asList(annotation.props()), p -> new BeanAssembleProperty(p.value(), p.src(), p.exp(), p.expType())));
        Stream.of(annotation.propTemplates()).map(this::parsePropsTemplateAnnotation).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).forEach(properties::add);
        return new BeanAssembleOperation(ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)property, Order.class), Order::value, Integer.MAX_VALUE), configuration, property, aliases, annotation.namespace(), container, configuration.getOperatorFactory().getAssembler(), properties);
    }

    protected List<AssembleProperty> parsePropsTemplateAnnotation(Class<?> targetClass) {
        PropsTemplate annotation = (PropsTemplate)AnnotatedElementUtils.findMergedAnnotation(targetClass, PropsTemplate.class);
        if (Objects.isNull(annotation)) {
            return Collections.emptyList();
        }
        return Stream.of(annotation.value()).map(p -> new BeanAssembleProperty(p.value(), p.src(), p.exp(), p.expType())).collect(Collectors.toList());
    }

    protected List<DisassembleOperation> parseDisassembleAnnotation(Field property, BeanOperationConfiguration configuration, ParseContext parseContext) {
        OperationConfiguration operationConfiguration;
        Disassemble disassemble = (Disassemble)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)property, Disassemble.class);
        if (Objects.isNull(disassemble)) {
            return Collections.emptyList();
        }
        CraneException.throwIfTrue(AnnotatedElementUtils.hasAnnotation((AnnotatedElement)property, Assemble.class), "[%s]\u5c5e\u6027[$s]\u65e0\u6cd5\u540c\u65f6\u88ab%s\u548c%s\u6ce8\u89e3\u6807\u8bb0", configuration.getTargetClass(), property, Assemble.class, Disassemble.class);
        parseContext.lookingFor(configuration);
        Class<?> operateClass = disassemble.value();
        if (parseContext.isInLooking(operateClass)) {
            log.info(CharSequenceUtil.format((CharSequence)"\u7c7b{}\u4e0e\u5d4c\u5957\u7684\u6210\u5458\u53d8\u91cf\u7c7b\u578b{}\u5f62\u6210\u5faa\u73af\u4f9d\u8d56...", (Object[])new Object[]{configuration.getTargetClass(), operateClass}));
            operationConfiguration = parseContext.getLookingForConfig(operateClass);
        } else {
            operationConfiguration = this.parse(operateClass, configuration.getOperatorFactory(), parseContext);
        }
        DisassembleOperation operation = this.createDisassembleOperation(property, disassemble, configuration, operationConfiguration, parseContext);
        parseContext.found(configuration);
        return Collections.singletonList(operation);
    }

    protected DisassembleOperation createDisassembleOperation(Field property, Disassemble annotation, BeanOperationConfiguration configuration, OperationConfiguration operationConfiguration, ParseContext parseContext) {
        Disassembler disassembler = operationConfiguration.getOperatorFactory().getDisassembler();
        Set<String> aliases = CollUtils.toSet(Arrays.asList(annotation.aliases()));
        return new BeanDisassembleOperation(ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)property, Order.class), Order::value, Integer.MAX_VALUE), configuration, disassembler, operationConfiguration, property, aliases);
    }

    public BeanOperateConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
        this.configuration = configuration;
        this.beanFactory = beanFactory;
    }

    public static class ParseContext {
        private final Map<Class<?>, OperationConfiguration> inLookingOption = new HashMap();

        public boolean isInLooking(Class<?> target) {
            return this.inLookingOption.containsKey(target);
        }

        public void lookingFor(OperationConfiguration target) {
            this.inLookingOption.put(target.getTargetClass(), target);
        }

        public OperationConfiguration getLookingForConfig(Class<?> target) {
            OperationConfiguration config = this.inLookingOption.get(target);
            Assert.notNull((Object)config, (String)String.format("\u7c7b[%s]\u4e0d\u5904\u4e8e\u89e3\u6790\u72b6\u6001\uff0c\u6216\u5df2\u7ecf\u5b8c\u6210\u89e3\u6790", target));
            return config;
        }

        public void found(OperationConfiguration config) {
            Class<?> foundClass = config.getTargetClass();
            Assert.notNull((Object)config, (String)String.format("\u7c7b[%s]\u4e0d\u5904\u4e8e\u89e3\u6790\u72b6\u6001\uff0c\u6216\u5df2\u7ecf\u5b8c\u6210\u89e3\u6790", foundClass));
        }
    }
}

