/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiValueTableMap<R, C, V> {
    private final Map<R, Multimap<C, V>> rowMap = new HashMap<R, Multimap<C, V>>();

    public Multimap<C, V> getColMap(R rowKey) {
        return this.rowMap.get(rowKey);
    }

    public void putVal(R rowKey, C colKey, V val) {
        this.getOrCreate(rowKey).put(colKey, val);
    }

    public void putValAll(R rowKey, C colKey, Collection<V> val) {
        if (CollUtil.isNotEmpty(val)) {
            Multimap colMap = this.getOrCreate(rowKey);
            val.forEach(v -> colMap.put(colKey, v));
        }
    }

    public Map<R, Multimap<C, V>> asMap() {
        return this.rowMap;
    }

    private Multimap<C, V> getOrCreate(R rowKey) {
        return this.rowMap.computeIfAbsent(rowKey, rk -> ArrayListMultimap.create());
    }
}

