/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper.reflex;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import top.xiajibagao.crane.core.helper.reflex.BeanProperty;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class BeanPropertyFactory {
    private final ConcurrentMap<Class<?>, ConcurrentMap<String, Optional<BeanProperty>>> propertiesCache = new ConcurrentHashMap();
    private final BiFunction<Class<?>, Field, BeanProperty> propertyFactory;

    public Optional<BeanProperty> getProperty(Class<?> targetClass, String fieldName) {
        ConcurrentMap properties = this.propertiesCache.computeIfAbsent(targetClass, t -> new ConcurrentHashMap(16));
        return properties.computeIfAbsent(fieldName, fn -> this.createProperty(targetClass, (String)fn));
    }

    private Optional<BeanProperty> createProperty(Class<?> targetClass, String fieldName) {
        Field field = ReflexUtils.findField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.propertyFactory.apply(targetClass, field));
    }

    public BeanPropertyFactory(BiFunction<Class<?>, Field, BeanProperty> propertyFactory) {
        this.propertyFactory = propertyFactory;
    }
}

