/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.DefaultGroup;
import top.xiajibagao.crane.core.helper.FuncUtils;
import top.xiajibagao.crane.core.helper.SFunc;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;
import top.xiajibagao.crane.core.operator.interfaces.Assembler;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.parser.BeanAssembleOperation;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.BeanDisassembleOperation;
import top.xiajibagao.crane.core.parser.BeanOperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class OperateConfigurationAssistant<T> {
    private final OperationConfiguration configuration;

    public static <T> OperateConfigurationAssistant<T> basedOn(OperationConfiguration configuration) {
        return new OperateConfigurationAssistant<T>(configuration);
    }

    public static <T> OperateConfigurationAssistant<T> basedOnBeanOperationConfiguration(GlobalConfiguration globalConfiguration, Class<T> targetClass) {
        return new OperateConfigurationAssistant<T>(new BeanOperationConfiguration(globalConfiguration, targetClass, new ArrayList<AssembleOperation>(), new ArrayList<DisassembleOperation>()));
    }

    public AssembleOperationBuilder<T> buildAssembler(String keyProperty, @Nonnull Container container, @Nonnull Assembler assembler) {
        Field keyField = ReflexUtils.findField(this.configuration.getTargetClass(), keyProperty);
        Assert.notNull((Object)keyField, (String)"\u7c7b[{}]\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027[{}]", (Object[])new Object[]{this.configuration.getTargetClass(), keyProperty});
        return new AssembleOperationBuilder(this, keyField, container, assembler);
    }

    public AssembleOperationBuilder<T> buildAssembler(@Nonnull SFunc<T, ?> keyFunc, @Nonnull Container container, @Nonnull Assembler assembler) {
        return this.buildAssembler(FuncUtils.getPropertyName(keyFunc), container, assembler);
    }

    public DisassembleOperationBuilder<T> buildDisassembler(@Nonnull String property, @Nonnull OperationConfiguration targetOperateConfiguration, @Nonnull Disassembler assembler) {
        Field keyField = ReflexUtils.findField(this.configuration.getTargetClass(), property);
        Assert.notNull((Object)keyField, (String)"\u7c7b[{}]\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027[{}]", (Object[])new Object[]{this.configuration.getTargetClass(), property});
        return new DisassembleOperationBuilder(this, keyField, targetOperateConfiguration, assembler);
    }

    public DisassembleOperationBuilder<T> buildDisassembler(@Nonnull SFunc<T, ?> propertyFunc, @Nonnull OperationConfiguration targetOperateConfiguration, @Nonnull Disassembler disassembler) {
        return this.buildDisassembler(FuncUtils.getPropertyName(propertyFunc), targetOperateConfiguration, disassembler);
    }

    private OperateConfigurationAssistant(OperationConfiguration configuration) {
        this.configuration = configuration;
    }

    public OperationConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class AssembleOperationBuilder<T> {
        private final OperateConfigurationAssistant<T> builder;
        private final Field targetField;
        private final Container container;
        private final Set<String> aliases = new HashSet<String>();
        private final List<AssembleProperty> properties = new ArrayList<AssembleProperty>();
        private final Assembler assembler;
        private String namespace = "";
        private int order = 0;

        public AssembleOperationBuilder<T> aliases(String ... aliases) {
            if (ArrayUtil.isNotEmpty((Object[])aliases)) {
                this.aliases.addAll(Arrays.asList(aliases));
            }
            return this;
        }

        public AssembleOperationBuilder<T> sort(int order) {
            this.order = order;
            return this;
        }

        public AssembleOperationBuilder<T> namespace(String namespace) {
            this.namespace = CharSequenceUtil.blankToDefault((CharSequence)namespace, (String)"");
            return this;
        }

        public AssembleOperationBuilder<T> properties(Collection<AssembleProperty> properties) {
            if (CollUtil.isNotEmpty(properties)) {
                this.properties.addAll(properties);
            }
            return this;
        }

        public AssembleOperationBuilder<T> property(String resource, String reference) {
            return this.property(resource, reference, "", Void.class);
        }

        public AssembleOperationBuilder<T> property(String resource, String reference, String exp, Class<?> expType) {
            this.properties.add(new BeanAssembleProperty(CharSequenceUtil.blankToDefault((CharSequence)reference, (String)""), CharSequenceUtil.blankToDefault((CharSequence)resource, (String)""), exp, expType));
            return this;
        }

        public AssembleOperationBuilder<T> property(String resource, SFunc<T, ?> reference) {
            return this.property(resource, FuncUtils.getPropertyName(reference));
        }

        public <S> AssembleOperationBuilder<T> property(SFunc<S, ?> resource, SFunc<T, ?> reference) {
            return this.property(FuncUtils.getPropertyName(resource), FuncUtils.getPropertyName(reference));
        }

        public AssembleOperationBuilder<T> onlyRefProperty(SFunc<T, ?> reference) {
            return this.property("", FuncUtils.getPropertyName(reference));
        }

        public AssembleOperationBuilder<T> onlyRefProperty(String reference) {
            return this.property("", reference);
        }

        public <S> AssembleOperationBuilder<T> onlySrcProperty(SFunc<S, ?> resource) {
            return this.property(FuncUtils.getPropertyName(resource), "");
        }

        public AssembleOperationBuilder<T> onlySrcProperty(String resource) {
            return this.property(resource, "");
        }

        public OperateConfigurationAssistant<T> build(Class<?> ... groups) {
            ((OperateConfigurationAssistant)this.builder).configuration.getAssembleOperations().add(new BeanAssembleOperation(this.order, ((OperateConfigurationAssistant)this.builder).configuration, this.targetField, this.aliases, this.namespace, this.container, this.assembler, this.properties, ArrayUtil.isNotEmpty((Object[])groups) ? CollUtil.newHashSet((Object[])groups) : CollUtil.newHashSet((Object[])new Class[]{DefaultGroup.class})));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> getBuilder() {
            return this.builder;
        }

        public Field getTargetField() {
            return this.targetField;
        }

        public Container getContainer() {
            return this.container;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public List<AssembleProperty> getProperties() {
            return this.properties;
        }

        public Assembler getAssembler() {
            return this.assembler;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public int getOrder() {
            return this.order;
        }

        public AssembleOperationBuilder(OperateConfigurationAssistant<T> builder, Field targetField, Container container, Assembler assembler) {
            this.builder = builder;
            this.targetField = targetField;
            this.container = container;
            this.assembler = assembler;
        }
    }

    public static class DisassembleOperationBuilder<T> {
        private final OperateConfigurationAssistant<T> builder;
        private final Field targetField;
        private int sort = 0;
        private final Set<String> aliases = new HashSet<String>();
        private final OperationConfiguration targetOperateConfiguration;
        private final Disassembler disassembler;

        public DisassembleOperationBuilder<T> aliases(String ... aliases) {
            if (ArrayUtil.isNotEmpty((Object[])aliases)) {
                this.aliases.addAll(Arrays.asList(aliases));
            }
            return this;
        }

        public DisassembleOperationBuilder<T> sort(int sort) {
            this.sort = sort;
            return this;
        }

        public OperateConfigurationAssistant<T> operation(Function<DisassembleOperationBuilder<T>, DisassembleOperation> operationFactory) {
            ((OperateConfigurationAssistant)this.builder).configuration.getDisassembleOperations().add(operationFactory.apply(this));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> build() {
            ((OperateConfigurationAssistant)this.builder).configuration.getDisassembleOperations().add(new BeanDisassembleOperation(this.sort, ((OperateConfigurationAssistant)this.builder).configuration, this.disassembler, this.targetOperateConfiguration, this.targetField, this.aliases));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> getBuilder() {
            return this.builder;
        }

        public Field getTargetField() {
            return this.targetField;
        }

        public int getSort() {
            return this.sort;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public OperationConfiguration getTargetOperateConfiguration() {
            return this.targetOperateConfiguration;
        }

        public Disassembler getDisassembler() {
            return this.disassembler;
        }

        public DisassembleOperationBuilder(OperateConfigurationAssistant<T> builder, Field targetField, OperationConfiguration targetOperateConfiguration, Disassembler disassembler) {
            this.builder = builder;
            this.targetField = targetField;
            this.targetOperateConfiguration = targetOperateConfiguration;
            this.disassembler = disassembler;
        }
    }
}

