/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.function.Supplier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.crane.core.handler.BeanReflexOperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.ExpressionUtils;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;

public class ExpressibleBeanReflexOperateHandlerChain
extends BeanReflexOperateHandlerChain
implements OperateHandlerChain {
    private final Supplier<StandardEvaluationContext> contextFactory;

    public ExpressibleBeanReflexOperateHandlerChain(Supplier<StandardEvaluationContext> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (CharSequenceUtil.isBlank((CharSequence)property.getExp())) {
            super.writeToTarget(sourceData, target, property, operation);
            return;
        }
        StandardEvaluationContext context = this.contextFactory.get();
        context.setVariable("target", target);
        context.setVariable("source", sourceData);
        context.setVariable("key", operation.getAssembler().getKey(target, operation));
        context.setVariable("src", (Object)property.getResource());
        context.setVariable("ref", (Object)property.getReference());
        sourceData = ExpressionUtils.execute(property.getExp(), (EvaluationContext)context, property.getExpType(), true);
        super.writeToTarget(sourceData, target, property, operation);
    }

    public Supplier<StandardEvaluationContext> getContextFactory() {
        return this.contextFactory;
    }
}

