/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import java.util.Map;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;

public class MapOperateHandler
implements OperateHandler {
    @Override
    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return ClassUtils.isAssignable(Map.class, source.getClass());
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return ClassUtils.isAssignable(Map.class, target.getClass());
    }

    @Override
    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source)) {
            return null;
        }
        Map<String, Object> sourceMap = this.parseMap(source);
        return property.hasResource() ? sourceMap.get(property.getResource()) : sourceMap;
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (Objects.isNull(sourceData) || Objects.isNull(target)) {
            return;
        }
        Map<String, Object> targetMap = this.parseMap(target);
        if (property.hasReference()) {
            targetMap.put(operation.getTargetProperty().getName(), sourceData);
            return;
        }
        targetMap.put(property.getReference(), sourceData);
    }

    private Map<String, Object> parseMap(Object data) {
        return (Map)data;
    }
}

