/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper.reflex;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.springframework.util.Assert;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.helper.reflex.BeanProperty;
import top.xiajibagao.crane.core.helper.reflex.BeanPropertyFactory;
import top.xiajibagao.crane.core.helper.reflex.IndexedMethod;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class AsmReflexUtils {
    private static final Map<Class<?>, MethodAccess> METHOD_ACCESS_CACHE = new ConcurrentHashMap();
    private static final BeanPropertyFactory ASM_REFLEX_PROPERTY_FACTORY = new BeanPropertyFactory((targetClass, field) -> {
        int getterIndex = AsmReflexUtils.findGetterMethodIndex(targetClass, field.getName());
        Assert.isTrue((getterIndex > -1 ? 1 : 0) != 0, (String)String.format("\u5c5e\u6027[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Getter\u65b9\u6cd5", field));
        int setterIndex = AsmReflexUtils.findSetterMethodIndex(targetClass, field.getName(), field.getType());
        Assert.isTrue((setterIndex > -1 ? 1 : 0) != 0, (String)String.format("\u5c5e\u6027[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Setter\u65b9\u6cd5", field));
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        return new AsmReflexBeanProperty((Class<?>)targetClass, (Field)field, new IndexedMethod(methodAccess, getterIndex), new IndexedMethod(methodAccess, setterIndex));
    });

    private AsmReflexUtils() {
    }

    @Nonnull
    public static Optional<BeanProperty> findProperty(Class<?> targetClass, String fieldName) {
        return ASM_REFLEX_PROPERTY_FACTORY.getProperty(targetClass, fieldName);
    }

    public static int findSetterMethodIndex(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        Method setter = ReflexUtils.findSetterMethod(targetClass, fieldName, fieldType);
        return Objects.isNull(setter) ? -1 : methodAccess.getIndex(setter.getName(), (Class[])setter.getParameterTypes());
    }

    public static int findGetterMethodIndex(Class<?> targetClass, String fieldName) {
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        Method getter = ReflexUtils.findGetterMethod(targetClass, fieldName);
        return Objects.isNull(getter) ? -1 : methodAccess.getIndex(getter.getName(), (Class[])getter.getParameterTypes());
    }

    public static MethodAccess getMethodAccess(Class<?> targetClass) {
        return METHOD_ACCESS_CACHE.computeIfAbsent(targetClass, MethodAccess::get);
    }

    public static IndexedMethod findMethod(Class<?> targetClass, String methodName, Class<?> ... paramTypes) {
        MethodAccess methodAccess = MethodAccess.get(targetClass);
        return new IndexedMethod(methodAccess, methodAccess.getIndex(methodName, (Class[])paramTypes));
    }

    public static IndexedMethod findMethod(Class<?> targetClass, Method method) {
        MethodAccess methodAccess = MethodAccess.get(targetClass);
        return new IndexedMethod(methodAccess, methodAccess.getIndex(method.getName(), (Class[])method.getParameterTypes()));
    }

    public static class AsmReflexBeanProperty
    implements BeanProperty {
        private final Class<?> targetClass;
        private final Field field;
        private final IndexedMethod getter;
        private final IndexedMethod setter;

        @Override
        public Object getValue(Object target) {
            return ObjectUtils.computeIfNotNull(target, x$0 -> this.getter.invoke(x$0, new Object[0]));
        }

        @Override
        public void setValue(Object target, Object value) {
            this.setter.invoke(target, value);
        }

        public AsmReflexBeanProperty(Class<?> targetClass, Field field, IndexedMethod getter, IndexedMethod setter) {
            this.targetClass = targetClass;
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public Class<?> targetClass() {
            return this.targetClass;
        }

        @Override
        public Field field() {
            return this.field;
        }
    }
}

