/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper.reflex;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.helper.reflex.BeanProperty;
import top.xiajibagao.crane.core.helper.reflex.BeanPropertyFactory;

public class ReflexUtils {
    private static final BeanPropertyFactory REFLEX_PROPERTY_FACTORY = new BeanPropertyFactory((targetClass, field) -> {
        Method getter = ReflexUtils.findGetterMethod(targetClass, field);
        Assert.notNull((Object)getter, (String)"\u5c5e\u6027{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Getter\u65b9\u6cd5", (Object[])new Object[]{field});
        Method setter = ReflexUtils.findSetterMethod(targetClass, field);
        Assert.notNull((Object)setter, (String)"\u5c5e\u6027{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Setter\u65b9\u6cd5", (Object[])new Object[]{field});
        return new ReflexBeanProperty((Class<?>)targetClass, (Field)field, getter, setter);
    });
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    private ReflexUtils() {
    }

    @Nullable
    public static Method findMethod(Class<?> targetClass, String methodName, boolean allowSubclasses, Class<?> returnType, Class<?> ... paramTypes) {
        return ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> {
            boolean returnTypeMatched;
            if (!Objects.equals(method.getName(), methodName)) {
                return false;
            }
            boolean bl = returnTypeMatched = allowSubclasses ? ClassUtils.isAssignable((Class)returnType, method.getReturnType()) : Objects.equals(returnType, method.getReturnType());
            if (!returnTypeMatched) {
                return false;
            }
            if (ArrayUtil.isNotEmpty((Object[])paramTypes)) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (paramTypes.length != parameterTypes.length) {
                    return false;
                }
                for (int i = 0; i < parameterTypes.length; ++i) {
                    boolean paramTypeMatched;
                    boolean bl2 = paramTypeMatched = allowSubclasses ? ClassUtils.isAssignable((Class)paramTypes[i], parameterTypes[i]) : Objects.equals(paramTypes[i], parameterTypes[i]);
                    if (paramTypeMatched) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public static Optional<BeanProperty> findProperty(Class<?> targetClass, String fieldName) {
        return REFLEX_PROPERTY_FACTORY.getProperty(targetClass, fieldName);
    }

    @Nullable
    public static Field findField(Class<?> targetClass, String fieldName) {
        return ReflexUtils.findField(targetClass, fieldName, false);
    }

    @Nullable
    public static Field findField(Class<?> targetClass, String fieldName, boolean mustExists) {
        Field field = ReflectionUtils.findField(targetClass, (String)fieldName);
        Assert.isTrue((!mustExists || Objects.nonNull(field) ? 1 : 0) != 0, (String)"\u7c7b[{}]\u627e\u4e0d\u5230\u540d\u4e3a[{}]\u7684\u5c5e\u6027", (Object[])new Object[]{targetClass, fieldName});
        return field;
    }

    public static Field findAnyMatchField(Class<?> targetClass, boolean mustExists, String ... fieldNames) {
        Field key = null;
        for (String field : fieldNames) {
            key = ReflexUtils.findField(targetClass, field, false);
            if (!Objects.nonNull(key)) continue;
            return key;
        }
        Assert.isFalse((boolean)mustExists, (String)"\u7c7b[{}]\u65e0\u6cd5\u4ece\u4ee5\u4e0b\u540d\u79f0\u4e2d\u627e\u5230\u4efb\u4f55\u4e00\u4e2a\u5b58\u5728\u7684\u5c5e\u6027\uff1a{}", (Object[])new Object[]{targetClass, Arrays.asList(fieldNames)});
        return null;
    }

    @Nullable
    public static Method findSetterMethod(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        String standardMethodName = ReflexUtils.getStandardMethodName(SET_PREFIX, fieldName);
        Method getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), standardMethodName) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable((Class)fieldType, method.getParameterTypes()[0]));
        if (Objects.nonNull(getter)) {
            return getter;
        }
        return ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), fieldName) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable((Class)fieldType, method.getParameterTypes()[0]));
    }

    @Nullable
    public static Method findSetterMethod(Class<?> targetClass, Field field) {
        return ReflexUtils.findSetterMethod(targetClass, field.getName(), field.getType());
    }

    @Nullable
    public static Method findGetterMethod(Class<?> targetClass, String fieldName) {
        Method getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), ReflexUtils.getStandardMethodName(GET_PREFIX, fieldName)) && method.getParameterTypes().length == 0);
        if (Objects.nonNull(getter)) {
            return getter;
        }
        getter = ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), ReflexUtils.getStandardMethodName(IS_PREFIX, fieldName)) && method.getParameterTypes().length == 0);
        return Objects.nonNull(getter) ? getter : ReflexUtils.findFromClass(targetClass, Class::getDeclaredMethods, method -> Objects.equals(method.getName(), fieldName) && method.getParameterTypes().length == 0);
    }

    @Nullable
    public static Method findGetterMethod(Class<?> targetClass, Field field) {
        return ReflexUtils.findGetterMethod(targetClass, field.getName());
    }

    public static void forEachClass(Class<?> targetClass, Predicate<Class<?>> filter, Consumer<Class<?>> classOperate) {
        LinkedList classDeque = CollUtil.newLinkedList((Object[])new Class[]{targetClass});
        HashSet<Class> operatedClass = new HashSet<Class>();
        while (!classDeque.isEmpty()) {
            Object[] interfaces;
            Class target = (Class)classDeque.removeFirst();
            if (Objects.isNull(target) || operatedClass.contains(target) || filter.negate().test(target)) continue;
            operatedClass.add(target);
            classOperate.accept(target);
            Class superClass = target.getSuperclass();
            if (!Objects.equals(superClass, Object.class) && Objects.nonNull(superClass)) {
                classDeque.addLast(superClass);
            }
            if (!ArrayUtil.isNotEmpty((Object[])(interfaces = target.getInterfaces()))) continue;
            CollUtil.addAll((Collection)classDeque, (Object[])interfaces);
        }
    }

    public static <T> void forEachFromClass(Class<?> targetClass, Function<Class<?>, T[]> targetMapping, Consumer<T> consumer) {
        while (!Objects.equals(targetClass, Object.class) && Objects.nonNull(targetClass)) {
            T[] targets = targetMapping.apply(targetClass);
            if (Objects.nonNull(targets)) {
                for (T t : targets) {
                    ObjectUtils.acceptIfNotNull(t, consumer);
                }
            }
            targetClass = targetClass.getSuperclass();
        }
    }

    @Nullable
    public static <T> T findFromClass(Class<?> targetClass, Function<Class<?>, T[]> targetMapping, Predicate<T> predicate) {
        while (!Objects.equals(targetClass, Object.class) && Objects.nonNull(targetClass)) {
            T[] targets = targetMapping.apply(targetClass);
            if (Objects.nonNull(targets)) {
                for (T t : targets) {
                    if (!predicate.test(t)) continue;
                    return t;
                }
            }
            targetClass = targetClass.getSuperclass();
        }
        return null;
    }

    private static String getStandardMethodName(String prefix, String name) {
        return CharSequenceUtil.upperFirstAndAddPre((CharSequence)name, (String)prefix);
    }

    public static class ReflexBeanProperty
    implements BeanProperty {
        private final Class<?> targetClass;
        private final Field field;
        private final Method getter;
        private final Method setter;

        @Override
        public Object getValue(Object target) {
            return ObjectUtils.computeIfNotNull(target, t -> ReflectionUtils.invokeMethod((Method)this.getter, (Object)t));
        }

        @Override
        public void setValue(Object target, Object value) {
            ReflectionUtils.invokeMethod((Method)this.setter, (Object)target, (Object[])new Object[]{value});
        }

        public ReflexBeanProperty(Class<?> targetClass, Field field, Method getter, Method setter) {
            this.targetClass = targetClass;
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public Class<?> targetClass() {
            return this.targetClass;
        }

        @Override
        public Field field() {
            return this.field;
        }
    }
}

