/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.operator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;

public class BeanReflexDisassembler
implements Disassembler {
    private final OperateHandlerChain handlerChain;

    @Override
    public Collection<?> execute(Object target, DisassembleOperation operation) {
        ArrayList results = new ArrayList();
        Object disassemblePropertyValue = this.handlerChain.readFromSource(target, BeanAssembleProperty.ofNameOnlyProperty(operation.getTargetProperty().getName()), operation);
        LinkedList<Object> deque = new LinkedList<Object>();
        deque.add(disassemblePropertyValue);
        while (!deque.isEmpty()) {
            CollUtils.adaptToCollection(deque.removeFirst()).stream().filter(Objects::nonNull).forEach(searchNode -> this.processNode(searchNode, deque, results, operation));
        }
        return results;
    }

    private void processNode(Object target, Deque<Object> searchQueue, List<Object> resultList, DisassembleOperation operation) {
        if (ClassUtils.isAssignable(Collection.class, target.getClass())) {
            searchQueue.addLast(target);
            return;
        }
        if (ClassUtils.isAssignable(operation.getTargetOperateConfiguration().getTargetClass(), target.getClass())) {
            resultList.add(target);
            return;
        }
        CraneException.throwOf("\u88c5\u5378\u5b57\u6bb5[{}]\u7c7b\u578b\u4e0d\u4e3aCollection\u6216\u6307\u5b9a\u7c7b\u578b[{}]", operation.getTargetProperty(), operation.getTargetOperateConfiguration().getTargetClass());
    }

    public BeanReflexDisassembler(OperateHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }
}

