/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.component;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import top.xiajibagao.crane.core.component.BeanProperty;
import top.xiajibagao.crane.core.component.BeanPropertyFactory;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public abstract class AbstractBeanPropertyFactory
implements BeanPropertyFactory {
    private final ConcurrentMap<Class<?>, ConcurrentMap<String, Optional<BeanProperty>>> propertiesCache = new ConcurrentHashMap();

    protected abstract BeanProperty createBeanProperty(Class<?> var1, Field var2);

    @Override
    public Optional<BeanProperty> getProperty(Class<?> targetClass, String fieldName) {
        ConcurrentMap properties = this.propertiesCache.computeIfAbsent(targetClass, t -> new ConcurrentHashMap(16));
        return properties.computeIfAbsent(fieldName, fn -> this.createProperty(targetClass, (String)fn));
    }

    private Optional<BeanProperty> createProperty(Class<?> targetClass, String fieldName) {
        Field field = ReflexUtils.findField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.createBeanProperty(targetClass, field));
    }
}

