/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.component;

import cn.hutool.core.lang.Assert;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import top.xiajibagao.crane.core.component.AbstractBeanPropertyFactory;
import top.xiajibagao.crane.core.component.BeanProperty;
import top.xiajibagao.crane.core.component.BeanPropertyFactory;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.helper.invoker.AsmReflexMethodInvoker;
import top.xiajibagao.crane.core.helper.invoker.MethodInvoker;
import top.xiajibagao.crane.core.helper.invoker.ParamTypeAutoConvertInvoker;
import top.xiajibagao.crane.core.helper.reflex.AsmReflexUtils;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class AsmReflexBeanPropertyFactory
extends AbstractBeanPropertyFactory
implements BeanPropertyFactory {
    @Override
    protected BeanProperty createBeanProperty(Class<?> targetClass, Field field) {
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        Method getter = ReflexUtils.findGetterMethod(targetClass, field);
        Assert.notNull((Object)getter, (String)"\u5c5e\u6027[{}]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Getter\u65b9\u6cd5", (Object[])new Object[]{field});
        int getterIndex = methodAccess.getIndex(getter.getName(), (Class[])getter.getParameterTypes());
        ParamTypeAutoConvertInvoker getterInvoker = new ParamTypeAutoConvertInvoker(getter.getParameterTypes(), new AsmReflexMethodInvoker(methodAccess, getterIndex));
        Method setter = ReflexUtils.findSetterMethod(targetClass, field);
        Assert.notNull((Object)setter, (String)"\u5c5e\u6027[{}]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Setter\u65b9\u6cd5", (Object[])new Object[]{field});
        int setterIndex = methodAccess.getIndex(setter.getName(), (Class[])setter.getParameterTypes());
        ParamTypeAutoConvertInvoker setterInvoker = new ParamTypeAutoConvertInvoker(setter.getParameterTypes(), new AsmReflexMethodInvoker(methodAccess, setterIndex));
        return new AsmReflexBeanProperty(targetClass, field, getterInvoker, setterInvoker);
    }

    public static class AsmReflexBeanProperty
    implements BeanProperty {
        private final Class<?> targetClass;
        private final Field field;
        private final MethodInvoker getter;
        private final MethodInvoker setter;

        @Override
        public Object getValue(Object target) {
            return ObjectUtils.computeIfNotNull(target, x$0 -> this.getter.invoke(x$0, new Object[0]));
        }

        @Override
        public void setValue(Object target, Object value) {
            ObjectUtils.computeIfNotNull(target, t -> this.setter.invoke(t, value));
        }

        public AsmReflexBeanProperty(Class<?> targetClass, Field field, MethodInvoker getter, MethodInvoker setter) {
            this.targetClass = targetClass;
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public Class<?> targetClass() {
            return this.targetClass;
        }

        @Override
        public Field field() {
            return this.field;
        }
    }
}

