/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public class CollectionOperateHandler
implements OperateHandler {
    private final OperateHandlerChain handlerChain;

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return source instanceof Collection;
    }

    @Override
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        Collection<Object> sourceColl = this.parseCollection(source);
        if (CollUtil.isEmpty(sourceColl)) {
            return null;
        }
        if (!property.hasResource()) {
            return source;
        }
        return sourceColl.stream().map(t -> this.handlerChain.readFromSource(t, property, operation)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return target instanceof Collection;
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        Collection<Object> targetColl = this.parseCollection(target);
        if (CollUtil.isEmpty(targetColl)) {
            return;
        }
        targetColl.forEach(t -> this.handlerChain.writeToTarget(sourceData, t, property, operation));
    }

    private Collection<Object> parseCollection(Object data) {
        return (Collection)data;
    }

    public CollectionOperateHandler(OperateHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }
}

