/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler.interfaces;

import java.util.List;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.SourceOperateInterceptor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public interface OperateHandlerChain
extends OperateHandler {
    public List<SourceOperateInterceptor> interceptors();

    public OperateHandlerChain addInterceptor(SourceOperateInterceptor var1);

    public List<OperateHandler> handlers();

    public OperateHandlerChain addHandler(OperateHandler var1);

    @Override
    default public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return this.handlers().stream().anyMatch(h -> h.sourceCanRead(source, property, operation));
    }

    @Override
    default public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        for (SourceOperateInterceptor interceptor : this.interceptors()) {
            if (!interceptor.supportInterceptReadSource(source, property, operation)) continue;
            source = interceptor.interceptReadSource(source, property, operation);
        }
        Object interceptedSources = source;
        return this.handlers().stream().filter(h -> h.sourceCanRead(interceptedSources, property, operation)).findFirst().map(h -> h.readFromSource(interceptedSources, property, operation)).orElse(null);
    }

    default public Object tryReadFromSource(Object source, PropertyMapping property, Operation operation) {
        return this.sourceCanRead(source, property, operation) ? this.readFromSource(source, property, operation) : null;
    }

    @Override
    default public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return this.handlers().stream().anyMatch(h -> h.targetCanWrite(sourceData, target, property, operation));
    }

    @Override
    default public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        for (SourceOperateInterceptor interceptor : this.interceptors()) {
            if (!interceptor.supportInterceptSourceWrite(sourceData, target, property, operation)) continue;
            sourceData = interceptor.interceptSourceWrite(sourceData, target, property, operation);
        }
        Object interceptedSourcesData = sourceData;
        this.handlers().stream().filter(h -> h.targetCanWrite(interceptedSourcesData, target, property, operation)).findFirst().ifPresent(h -> h.writeToTarget(interceptedSourcesData, target, property, operation));
    }

    default public void tryWriteToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        if (this.targetCanWrite(sourceData, target, property, operation)) {
            this.writeToTarget(sourceData, target, property, operation);
        }
    }
}

