/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class BeanFactoryUtils {
    private BeanFactoryUtils() {
    }

    @Nonnull
    public static <T> T getBean(@Nonnull BeanFactory beanFactory, @Nonnull Class<T> beanType, @Nullable String beanName) {
        Object target = null;
        if (CharSequenceUtil.isBlank((CharSequence)beanName)) {
            target = beanFactory.getBean(beanType);
            Assert.notNull((Object)target, () -> new NoSuchBeanDefinitionException(beanType));
            return (T)target;
        }
        target = beanFactory.getBean(beanName, beanType);
        Assert.notNull((Object)target, () -> new NoSuchBeanDefinitionException(CharSequenceUtil.format((CharSequence)"not bean of type {} and named {} available", (Object[])new Object[]{beanType, beanName})));
        return (T)target;
    }
}

