/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.annotation.Assemble;
import top.xiajibagao.crane.core.annotation.Disassemble;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.helper.BeanFactoryUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.helper.Orderly;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;
import top.xiajibagao.crane.core.parser.AbstractAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.BeanOperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class FieldAnnotationConfigurationParser
extends AbstractAnnotationConfigurationParser
implements OperateConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(FieldAnnotationConfigurationParser.class);

    public FieldAnnotationConfigurationParser(GlobalConfiguration globalConfiguration, BeanFactory beanFactory) {
        super(globalConfiguration, beanFactory);
    }

    @Override
    @Nonnull
    protected BeanOperationConfiguration parse(Class<?> targetClass, AbstractAnnotationConfigurationParser.ParseContext parseContext) {
        BeanOperationConfiguration operationConfiguration = this.createConfiguration(targetClass);
        ArrayList assembleOperations = new ArrayList();
        ArrayList disassembleOperations = new ArrayList();
        ReflexUtils.forEachFromClass(targetClass, Class::getDeclaredFields, f -> {
            assembleOperations.addAll(this.parseAssembleAnnotationOnField((Field)f, operationConfiguration));
            disassembleOperations.addAll(this.parseDisassembleAnnotationOnField((Field)f, operationConfiguration, parseContext));
        });
        operationConfiguration.getAssembleOperations().addAll(CollUtil.sort(assembleOperations, Orderly::compareTo));
        operationConfiguration.getDisassembleOperations().addAll(CollUtil.sort(disassembleOperations, Orderly::compareTo));
        return operationConfiguration;
    }

    @Nonnull
    protected BeanOperationConfiguration createConfiguration(Class<?> targetClass) {
        return new BeanOperationConfiguration(this.globalConfiguration, targetClass, new ArrayList<AssembleOperation>(), new ArrayList<DisassembleOperation>());
    }

    protected List<AssembleOperation> parseAssembleAnnotationOnField(Field key, BeanOperationConfiguration configuration) {
        Assemble assemble = (Assemble)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)key, Assemble.class);
        List operations = ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)key, Assemble.List.class), list -> CollStreamUtil.toList(Arrays.asList(list.value()), a -> this.createAssembleOperation(key, (Assemble)a, configuration)), new ArrayList());
        if (Objects.nonNull(assemble)) {
            operations.add(this.createAssembleOperation(key, assemble, configuration));
        }
        CraneException.throwIfFalse(CollectionUtils.isEmpty((Collection)operations) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)key, Disassemble.class), "\u5c5e\u6027[%s]\u65e0\u6cd5\u540c\u65f6\u88ab%s\u548c%s\u6ce8\u89e3\u6807\u8bb0", configuration.getTargetClass(), key, Assemble.class, Disassemble.class);
        return operations;
    }

    protected List<DisassembleOperation> parseDisassembleAnnotationOnField(Field key, BeanOperationConfiguration configuration, AbstractAnnotationConfigurationParser.ParseContext parseContext) {
        OperationConfiguration disassembleConfiguration;
        Disassemble annotation = (Disassemble)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)key, Disassemble.class);
        if (Objects.isNull(annotation)) {
            return Collections.emptyList();
        }
        CraneException.throwIfTrue(AnnotatedElementUtils.hasAnnotation((AnnotatedElement)key, Assemble.class), "\u5c5e\u6027[%s]\u65e0\u6cd5\u540c\u65f6\u88ab%s\u548c%s\u6ce8\u89e3\u6807\u8bb0", configuration.getTargetClass(), key, Assemble.class, Disassemble.class);
        parseContext.looking(configuration.getTargetClass(), configuration);
        Class<?> disassembleType = annotation.value();
        if (parseContext.isInLooking(disassembleType)) {
            log.info("\u7c7b{}\u4e0e\u5d4c\u5957\u7684\u6210\u5458\u53d8\u91cf\u7c7b\u578b{}\u5f62\u6210\u5faa\u73af\u4f9d\u8d56...", configuration.getTargetClass(), disassembleType);
            disassembleConfiguration = parseContext.get(disassembleType);
        } else {
            disassembleConfiguration = annotation.useCurrParser() ? this.parse((Class)disassembleType, parseContext) : BeanFactoryUtils.getBean(this.beanFactory, annotation.parser(), annotation.parserName()).parse(disassembleType);
        }
        DisassembleOperation operation = this.createDisassembleOperation(key, annotation, configuration, disassembleConfiguration);
        return Collections.singletonList(operation);
    }
}

