/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import java.util.Objects;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.helper.property.BeanPropertyFactory;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public class BeanOperateHandler
implements OperateHandler {
    private final BeanPropertyFactory beanPropertyFactory;

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return Objects.nonNull(source);
    }

    @Override
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        if (property.hasResource()) {
            return this.beanPropertyFactory.getProperty(source.getClass(), property.getSource()).map(bp -> bp.getValue(source)).orElse(null);
        }
        return source;
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return Objects.nonNull(target);
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        String operateProperty = property.hasReference() ? property.getReference() : operation.getTargetProperty().getName();
        this.beanPropertyFactory.getProperty(target.getClass(), operateProperty).ifPresent(bp -> bp.setValue(target, sourceData));
    }

    public BeanOperateHandler(BeanPropertyFactory beanPropertyFactory) {
        this.beanPropertyFactory = beanPropertyFactory;
    }
}

