/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class EnumDict {
    private static final Logger log = LoggerFactory.getLogger(EnumDict.class);
    private final Map<String, EnumDictType<?>> nameCache = new HashMap();
    private final Map<Class<?>, EnumDictType<?>> classCache = new HashMap();
    private static final EnumDict INSTANCE = new EnumDict();

    public static EnumDict instance() {
        return INSTANCE;
    }

    public <T extends Enum<?>> void register(Class<T> targetType) {
        this.register(targetType, null, null);
    }

    public <T extends Enum<?>> void unregister(Class<T> targetType) {
        Optional.ofNullable(this.classCache.remove(targetType)).ifPresent(t -> this.nameCache.remove(t.getName()));
    }

    public void unregister(String targetTypeName) {
        Optional.ofNullable(this.nameCache.remove(targetTypeName)).ifPresent(t -> this.classCache.remove(t.getType()));
    }

    public <T extends Enum<?>> void register(Class<T> targetType, String typeName, Function<T, String> itemNameGetter) {
        Item annotation = (Item)AnnotatedElementUtils.findMergedAnnotation(targetType, Item.class);
        if (Objects.nonNull(annotation)) {
            typeName = annotation.typeName();
            itemNameGetter = t -> Optional.ofNullable(ReflexUtils.findGetterMethod(targetType, annotation.itemNameProperty())).map(m -> ReflectUtil.invoke((Object)t, (Method)m, (Object[])new Object[0])).map(String::valueOf).orElseThrow(() -> new IllegalArgumentException(CharSequenceUtil.format((CharSequence)"\u679a\u4e3e\u9879\u540d\u79f0\u4e3a\u7a7a\uff0c\u679a\u4e3e\u7c7b{}\u65e0\u6cd5\u6ce8\u518c\u5230\u5b57\u5178", (Object[])new Object[0])));
        }
        typeName = ObjectUtils.defaultIfNull(typeName, targetType.getSimpleName());
        itemNameGetter = ObjectUtils.defaultIfNull(itemNameGetter, Enum::name);
        EnumDictType<T> type = new EnumDictType<T>(targetType, typeName);
        ArrayList<EnumDictItem<Enum>> targets = new ArrayList<EnumDictItem<Enum>>();
        for (Enum item : (Enum[])targetType.getEnumConstants()) {
            targets.add(new EnumDictItem<Enum>(type, item, itemNameGetter.apply(item)));
        }
        targets.forEach(type::addItem);
        log.info("\u6ce8\u518c\u679a\u4e3e[{}]({})\uff1a[{}]", new Object[]{typeName, targetType, targets.stream().map(t -> CharSequenceUtil.format((CharSequence)"{}->{}", (Object[])new Object[]{t.getName(), ((Enum)t.getTarget()).name()})).collect(Collectors.joining(", "))});
        this.nameCache.put(typeName, type);
        this.classCache.put(targetType, type);
    }

    public <T extends Enum<?>> EnumDictType<T> getType(String typeName) {
        return this.nameCache.get(typeName);
    }

    public <T extends Enum<?>> EnumDictType<T> getType(Class<T> enumClass) {
        return this.classCache.get(enumClass);
    }

    public <T extends Enum<?>> EnumDictItem<T> getItem(String typeName, String itemName) {
        EnumDictType<T> type = this.getType(typeName);
        return type == null ? null : type.get(itemName);
    }

    public <T extends Enum<?>> EnumDictItem<T> getItem(Class<T> enumClass, String itemName) {
        EnumDictType<T> type = this.getType(enumClass);
        return type == null ? null : type.get(itemName);
    }

    public <T extends Enum<?>> T getEnum(Class<T> enumClass, String itemName) {
        return (T)((Enum)Optional.ofNullable(this.getType(enumClass)).map(t -> t.get(itemName)).map(EnumDictItem::getTarget).orElse(null));
    }

    public <T extends Enum<?>> T getEnum(String typeName, String itemName) {
        return (T)((Enum)Optional.ofNullable(this.getType(typeName)).map(t -> t.get(itemName)).map(EnumDictItem::getTarget).orElse(null));
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Item {
        public String itemNameProperty();

        public String typeName();
    }

    public static class EnumDictItem<T extends Enum<?>>
    extends HashMap<String, Object> {
        private final transient EnumDictType<T> type;
        private final T target;
        private final String name;

        protected EnumDictItem(EnumDictType<T> type, T target, String name) {
            this.type = type;
            this.name = name;
            this.target = target;
            HashMap properties = new HashMap(BeanMap.create(target));
            properties.remove("declaringClass");
            this.putAll(properties);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumDictItem)) {
                return false;
            }
            EnumDictItem other = (EnumDictItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$target = this.getTarget();
            T other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumDictItem;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public EnumDictType<T> getType() {
            return this.type;
        }

        public T getTarget() {
            return this.target;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class EnumDictType<T extends Enum<?>> {
        private final Class<T> type;
        private final String name;
        private final Map<String, EnumDictItem<T>> nameCache;
        private final Map<Enum<?>, EnumDictItem<T>> enumCache;

        protected EnumDictType(Class<T> type, String name) {
            this.type = type;
            this.name = name;
            int len = ((Enum[])type.getEnumConstants()).length;
            this.nameCache = new HashMap<String, EnumDictItem<T>>(len);
            this.enumCache = new HashMap(len);
        }

        public EnumDictItem<T> get(@NonNull String itemName) {
            return this.nameCache.get(itemName);
        }

        public EnumDictItem<T> get(@NonNull Enum<?> target) {
            return this.enumCache.get(target);
        }

        public void addItem(EnumDictItem<T> item) {
            this.nameCache.put(item.getName(), item);
            this.enumCache.put((Enum<?>)item.getTarget(), item);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumDictType)) {
                return false;
            }
            EnumDictType other = (EnumDictType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumDictType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public Class<T> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, EnumDictItem<T>> getNameCache() {
            return this.nameCache;
        }

        public Map<Enum<?>, EnumDictItem<T>> getEnumCache() {
            return this.enumCache;
        }
    }
}

