/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T defaultIfNull(T target, T def) {
        return Objects.isNull(target) ? def : target;
    }

    public static <T, R> R supplyIfRight(T target, Predicate<T> predicate, Function<T, R> mapping, R def) {
        if (predicate.test(target)) {
            mapping.apply(target);
        }
        return def;
    }

    public static <T, R> R supplyIfFalse(T target, Predicate<T> predicate, Function<T, R> mapping, R def) {
        return ObjectUtils.supplyIfRight(target, predicate.negate(), mapping, def);
    }

    public static <T> void acceptIfRight(T target, Predicate<T> predicate, Consumer<T> consumer) {
        if (predicate.test(target)) {
            consumer.accept(target);
        }
    }

    public static <T> void acceptIfFalse(T target, Predicate<T> predicate, Consumer<T> consumer) {
        ObjectUtils.acceptIfRight(target, predicate.negate(), consumer);
    }

    public static <T> void acceptIfNotNull(T target, Consumer<T> consumer) {
        if (Objects.nonNull(target)) {
            consumer.accept(target);
        }
    }

    public static <T, R> R computeIfNotNull(T target, Function<T, R> mapping, R def) {
        return Objects.isNull(target) ? def : ObjectUtils.defaultIfNull(mapping.apply(target), def);
    }

    public static <T, R> R computeIfNotNull(T target, Function<T, R> mapping) {
        return ObjectUtils.computeIfNotNull(target, mapping, null);
    }

    public static <T, R> R computeIfMatch(T target, Predicate<T> predicate, Function<T, R> mapping, R def) {
        if (Objects.nonNull(target) && predicate.test(target)) {
            R result = mapping.apply(target);
            return ObjectUtils.defaultIfNull(result, def);
        }
        return def;
    }

    public static <T, R> R computeIfMatch(T target, Predicate<T> predicate, Function<T, R> mapping) {
        return ObjectUtils.computeIfMatch(target, predicate, mapping, null);
    }

    public static void tryAction(Runnable runnable, Consumer<Throwable> failAction) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            failAction.accept(e);
        }
    }

    public static <T> T trySupply(Supplier<T> supplier, Consumer<Throwable> failAction) {
        T result = null;
        try {
            result = supplier.get();
        }
        catch (Exception e) {
            failAction.accept(e);
        }
        return result;
    }

    public static <T> void tryAction(Supplier<T> supplier, Consumer<Throwable> failAction, Consumer<T> successAction) {
        try {
            T result = supplier.get();
            successAction.accept(result);
        }
        catch (Exception e) {
            failAction.accept(e);
        }
    }

    public static <T> boolean instanceOf(Object target, Class<T> targetClass, Consumer<T> consumer) {
        if (Objects.isNull(target) || !target.getClass().isAssignableFrom(targetClass)) {
            return false;
        }
        consumer.accept(targetClass.cast(target));
        return true;
    }
}

