/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import top.xiajibagao.crane.core.annotation.Assemble;
import top.xiajibagao.crane.core.annotation.Disassemble;
import top.xiajibagao.crane.core.annotation.Prop;
import top.xiajibagao.crane.core.annotation.PropsTemplate;
import top.xiajibagao.crane.core.helper.BeanFactoryUtils;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.parser.BeanAssembleOperation;
import top.xiajibagao.crane.core.parser.BeanDisassembleOperation;
import top.xiajibagao.crane.core.parser.BeanPropertyMapping;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public abstract class AbstractAnnotationConfigurationParser
implements OperateConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationConfigurationParser.class);
    protected final GlobalConfiguration globalConfiguration;
    protected final BeanFactory beanFactory;

    @Override
    @Nonnull
    public OperationConfiguration parse(Class<?> targetClass) {
        return this.parse(targetClass, new ParseContext());
    }

    @Nonnull
    protected abstract OperationConfiguration parse(Class<?> var1, ParseContext var2);

    protected AssembleOperation createAssembleOperation(Field key, Assemble annotation, OperationConfiguration configuration) {
        ArrayList<PropertyMapping> properties = new ArrayList<PropertyMapping>(CollStreamUtil.toList(Arrays.asList(annotation.props()), this::parsePropAnnotation));
        Stream.of(annotation.propTemplates()).map(this::parsePropsTemplateAnnotation).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).forEach(properties::add);
        return new BeanAssembleOperation(ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)key, Order.class), Order::value, Integer.MAX_VALUE), configuration, key, CollUtils.toSet(annotation.aliases()), annotation.namespace(), BeanFactoryUtils.getBean(this.beanFactory, annotation.container(), annotation.containerName()), BeanFactoryUtils.getBean(this.beanFactory, annotation.assembler(), annotation.assemblerName()), properties, CollUtils.toSet(annotation.groups()));
    }

    protected List<PropertyMapping> parsePropsTemplateAnnotation(Class<?> targetClass) {
        return AnnotatedElementUtils.findAllMergedAnnotations(targetClass, PropsTemplate.class).stream().filter(Objects::nonNull).map(PropsTemplate::value).filter(ArrayUtil::isNotEmpty).flatMap(Stream::of).map(this::parsePropAnnotation).collect(Collectors.toList());
    }

    protected PropertyMapping parsePropAnnotation(Prop annotation) {
        return new BeanPropertyMapping(annotation.value(), annotation.src(), annotation.exp(), annotation.expType());
    }

    protected DisassembleOperation createDisassembleOperation(Field key, Disassemble annotation, OperationConfiguration configuration, OperationConfiguration disassembleConfiguration) {
        return new BeanDisassembleOperation(ObjectUtils.computeIfNotNull(AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)key, Order.class), Order::value, Integer.MAX_VALUE), configuration, BeanFactoryUtils.getBean(this.beanFactory, annotation.disassembler(), annotation.disassemblerName()), disassembleConfiguration, key, CollUtils.toSet(annotation.aliases()));
    }

    public AbstractAnnotationConfigurationParser(GlobalConfiguration globalConfiguration, BeanFactory beanFactory) {
        this.globalConfiguration = globalConfiguration;
        this.beanFactory = beanFactory;
    }

    protected static class ParseContext {
        private final Map<Class<?>, OperationConfiguration> lookingForConfigurations;
        private final Set<Class<?>> excluded = new HashSet();

        public ParseContext() {
            this(new HashMap(4));
        }

        public boolean isInLooking(Class<?> targetClass) {
            return this.lookingForConfigurations.containsKey(targetClass);
        }

        public void looking(Class<?> targetClass, OperationConfiguration configuration) {
            this.lookingForConfigurations.put(targetClass, configuration);
        }

        public OperationConfiguration get(Class<?> targetClass) {
            return this.lookingForConfigurations.get(targetClass);
        }

        public void exclude(Class<?> ... excludeClass) {
            CollUtil.addAll(this.excluded, (Object[])excludeClass);
        }

        public boolean isExcluded(Class<?> targetClass) {
            return this.excluded.contains(targetClass);
        }

        public ParseContext(Map<Class<?>, OperationConfiguration> lookingForConfigurations) {
            this.lookingForConfigurations = lookingForConfigurations;
        }
    }
}

