/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import java.util.ArrayList;
import java.util.List;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.SourceOperateInterceptor;
import top.xiajibagao.crane.core.helper.Orderly;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public class AbstractOrderlyHandlerChain
implements OperateHandlerChain {
    protected final List<OperateHandler> handlers = new ArrayList<OperateHandler>();
    protected final List<SourceOperateInterceptor> interceptors = new ArrayList<SourceOperateInterceptor>();

    @Override
    public OperateHandlerChain addInterceptor(SourceOperateInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.interceptors.sort(Orderly::compareTo);
        return this;
    }

    @Override
    public OperateHandlerChain addHandler(OperateHandler handler) {
        this.handlers.add(handler);
        this.handlers.sort(Orderly::compareTo);
        return this;
    }

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return this.handlers().stream().anyMatch(h -> h.sourceCanRead(source, property, operation));
    }

    @Override
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        for (SourceOperateInterceptor interceptor : this.interceptors()) {
            if (!interceptor.supportInterceptReadSource(source, property, operation)) continue;
            source = interceptor.interceptReadSource(source, property, operation);
        }
        Object interceptedSources = source;
        return this.handlers().stream().filter(h -> h.sourceCanRead(interceptedSources, property, operation)).findFirst().map(h -> h.readFromSource(interceptedSources, property, operation)).orElse(null);
    }

    @Override
    public Object tryReadFromSource(Object source, PropertyMapping property, Operation operation) {
        return this.sourceCanRead(source, property, operation) ? this.readFromSource(source, property, operation) : null;
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return this.handlers().stream().anyMatch(h -> h.targetCanWrite(sourceData, target, property, operation));
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        for (SourceOperateInterceptor interceptor : this.interceptors()) {
            if (!interceptor.supportInterceptSourceWrite(sourceData, target, property, operation)) continue;
            sourceData = interceptor.interceptSourceWrite(sourceData, target, property, operation);
        }
        Object interceptedSourcesData = sourceData;
        this.handlers().stream().filter(h -> h.targetCanWrite(interceptedSourcesData, target, property, operation)).findFirst().ifPresent(h -> h.writeToTarget(interceptedSourcesData, target, property, operation));
    }

    @Override
    public void tryWriteToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        if (this.targetCanWrite(sourceData, target, property, operation)) {
            this.writeToTarget(sourceData, target, property, operation);
        }
    }

    @Override
    public List<OperateHandler> handlers() {
        return this.handlers;
    }

    @Override
    public List<SourceOperateInterceptor> interceptors() {
        return this.interceptors;
    }
}

