/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.executor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.stream.StreamUtil;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CounterSet;
import top.xiajibagao.crane.core.helper.Orderly;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class SequentialOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration, @Nonnull Set<Class<?>> groups) {
        if (CollUtil.isEmpty(targets) || Objects.isNull(configuration) || CollUtil.isEmpty(groups)) {
            return;
        }
        List<Object> targetsList = StreamUtil.of(targets).collect(Collectors.toList());
        Multimap<OperationConfiguration, Object> collectedConfigurations = this.collectOperationConfigurations(targetsList, configuration, (Multimap<OperationConfiguration, Object>)LinkedListMultimap.create());
        this.execute(groups, collectedConfigurations);
    }

    protected void execute(@Nonnull Set<Class<?>> targetGroups, @Nonnull Multimap<OperationConfiguration, Object> collectedConfigurations) {
        Set buckets = collectedConfigurations.asMap().entrySet().stream().filter(e -> CollUtil.isNotEmpty(((OperationConfiguration)e.getKey()).getAssembleOperations())).map(e -> new Bucket(((OperationConfiguration)e.getKey()).getAssembleOperations(), (Collection)e.getValue(), targetGroups)).collect(Collectors.toSet());
        LinkedListMultimap batch = LinkedListMultimap.create();
        while (CollUtil.isNotEmpty(buckets)) {
            Container maxContainer = (Container)new CounterSet<Object>().plusAll(buckets, Bucket::peekContainerOfFirstOperation).getMax();
            List matchedOperation = buckets.stream().map(b -> b.getOperations(maxContainer)).filter(Bucket::isNotEmpty).collect(Collectors.toList());
            batch.putAll((Object)maxContainer, matchedOperation);
            buckets = buckets.stream().filter(Bucket::isNotEmpty).collect(Collectors.toSet());
        }
        batch.asMap().forEach((container, bucketList) -> {
            List targets = bucketList.stream().map(Bucket::getTargets).flatMap(Collection::stream).collect(Collectors.toList());
            List<AssembleOperation> operations = bucketList.stream().map(Bucket::getOperations).flatMap(Collection::stream).collect(Collectors.toList());
            LinkedListMultimap processData = LinkedListMultimap.create();
            operations.forEach(arg_0 -> SequentialOperationExecutor.lambda$null$3((Multimap)processData, targets, arg_0));
            container.process((Multimap<AssembleOperation, ?>)processData);
        });
    }

    @Nonnull
    protected Multimap<OperationConfiguration, Object> collectOperationConfigurations(@Nonnull Collection<Object> targets, @Nonnull OperationConfiguration configuration, @Nonnull Multimap<OperationConfiguration, Object> collectedConfigurations) {
        if (CollectionUtils.isEmpty(targets)) {
            return collectedConfigurations;
        }
        targets.forEach(t -> collectedConfigurations.put((Object)configuration, t));
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return collectedConfigurations;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            DisassembleOperation.collect(operation, targets).asMap().forEach((config, values) -> this.collectOperationConfigurations((Collection<Object>)values, (OperationConfiguration)config, collectedConfigurations));
        }
        return collectedConfigurations;
    }

    private static /* synthetic */ void lambda$null$3(Multimap processData, List targets, AssembleOperation op) {
        processData.putAll((Object)op, (Iterable)targets);
    }

    private static class Bucket {
        private final List<AssembleOperation> operations;
        private final Collection<Object> targets;
        private final Set<Class<?>> targetGroups;

        public Bucket(List<AssembleOperation> operations, Collection<Object> targets, Set<Class<?>> targetGroups) {
            this.operations = operations.stream().filter(op -> CollUtil.containsAny((Collection)targetGroups, op.getGroups())).sorted(Orderly::compareTo).collect(Collectors.toList());
            this.targets = targets;
            this.targetGroups = targetGroups;
        }

        public Container peekContainerOfFirstOperation() {
            return this.isEmpty() ? null : ((AssembleOperation)CollUtil.getFirst(this.operations)).getContainer();
        }

        public Bucket getOperations(Container container) {
            AssembleOperation curr;
            ArrayList<AssembleOperation> matched = new ArrayList<AssembleOperation>();
            Iterator<AssembleOperation> iterator = this.operations.iterator();
            while (iterator.hasNext() && Objects.equals((curr = iterator.next()).getContainer(), container)) {
                matched.add(curr);
                iterator.remove();
            }
            return new Bucket(matched, this.targets, this.targetGroups);
        }

        public boolean isEmpty() {
            return CollectionUtils.isEmpty(this.operations);
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public List<AssembleOperation> getOperations() {
            return this.operations;
        }

        public Collection<Object> getTargets() {
            return this.targets;
        }

        public Set<Class<?>> getTargetGroups() {
            return this.targetGroups;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket other = (Bucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AssembleOperation> this$operations = this.getOperations();
            List<AssembleOperation> other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Collection<Object> this$targets = this.getTargets();
            Collection<Object> other$targets = other.getTargets();
            if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
                return false;
            }
            Set<Class<?>> this$targetGroups = this.getTargetGroups();
            Set<Class<?>> other$targetGroups = other.getTargetGroups();
            return !(this$targetGroups == null ? other$targetGroups != null : !((Object)this$targetGroups).equals(other$targetGroups));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bucket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AssembleOperation> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Collection<Object> $targets = this.getTargets();
            result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
            Set<Class<?>> $targetGroups = this.getTargetGroups();
            result = result * 59 + ($targetGroups == null ? 43 : ((Object)$targetGroups).hashCode());
            return result;
        }

        public String toString() {
            return "SequentialOperationExecutor.Bucket(operations=" + this.getOperations() + ", targets=" + this.getTargets() + ", targetGroups=" + this.getTargetGroups() + ")";
        }
    }
}

