/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import top.xiajibagao.crane.core.annotation.ProcessorComponent;
import top.xiajibagao.crane.core.handler.CollectionOperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

@ProcessorComponent(value={"JAVA_BEAN"})
public class ArrayOperateHandler
extends CollectionOperateHandler
implements OperateHandler {
    public ArrayOperateHandler(OperateProcessor operateProcessor) {
        super(operateProcessor, new String[0]);
    }

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return Objects.nonNull(source) && source.getClass().isArray();
    }

    @Override
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        if (ArrayUtil.isEmpty((Object)source)) {
            return null;
        }
        return super.readFromSource(Arrays.asList((Object[])source), property, operation);
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return Objects.nonNull(target) && target.getClass().isArray();
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        if (ArrayUtil.isNotEmpty((Object)target)) {
            super.writeToTarget(sourceData, Arrays.asList((Object[])target), property, operation);
        }
    }
}

