/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;

public class ExpressionUtils {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final Map<String, WeakReference<Expression>> EXPRESSION_CACHE = new ConcurrentHashMap<String, WeakReference<Expression>>();

    private ExpressionUtils() {
    }

    public static ExpressionParser getParser() {
        return PARSER;
    }

    public static Expression parseExp(@NonNull String exp, boolean cached) {
        return Optional.ofNullable(EXPRESSION_CACHE.get(exp)).map(Reference::get).orElseGet(() -> {
            Expression expression = PARSER.parseExpression(exp);
            if (cached) {
                EXPRESSION_CACHE.put(exp, new WeakReference<Expression>(expression));
            }
            return expression;
        });
    }

    public static <T> T execute(String exp, Class<T> resultType, boolean cached) {
        return (T)(CharSequenceUtil.isBlank((CharSequence)exp) ? null : ExpressionUtils.parseExp(exp, cached).getValue(resultType));
    }

    public static <T> T execute(String exp, EvaluationContext context, Class<T> resultType, boolean cached) {
        return (T)(CharSequenceUtil.isBlank((CharSequence)exp) ? null : ExpressionUtils.parseExp(exp, cached).getValue(context, resultType));
    }

    public static EvaluationContext registerMethodArgs(@NonNull Collection<String> paramNames, @NonNull Collection<Object> args, StandardEvaluationContext context) {
        Assert.isTrue((CollUtil.size(paramNames) == CollUtil.size(args) ? 1 : 0) != 0, (String)"\u53c2\u6570\u540d\u4e0e\u53c2\u6570\u4e2a\u6570\u4e0d\u4e00\u81f4: [{}]/[{}]", (Object[])new Object[]{CollUtil.size(paramNames), CollUtil.size(args)});
        CollUtil.zip(paramNames, args).forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).setVariable(arg_0, arg_1));
        return context;
    }
}

