/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.invoke.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import top.xiajibagao.crane.core.helper.SFunc;

public class FuncUtils {
    private static final Map<String, WeakReference<SerializedLambda>> SERIALIZED_LAMBDA_CACHE = new ConcurrentHashMap<String, WeakReference<SerializedLambda>>();
    private static final String WRITE_REPLACE = "writeReplace";

    private FuncUtils() {
    }

    public static <P> String getPropertyName(SFunc<P, ?> func) {
        String methodName = FuncUtils.getMethodName(func);
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return CharSequenceUtil.removePreAndLowerFirst((CharSequence)methodName, (int)3);
        }
        if (methodName.startsWith("is")) {
            return CharSequenceUtil.removePreAndLowerFirst((CharSequence)methodName, (int)2);
        }
        return methodName;
    }

    public static <P> String getMethodName(SFunc<P, ?> func) {
        return FuncUtils.resolve(func).getImplMethodName();
    }

    public static <P> SerializedLambda resolve(SFunc<P, ?> func) {
        return Optional.ofNullable(SERIALIZED_LAMBDA_CACHE.get(func.getClass().getName())).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = (SerializedLambda)ReflectUtil.invoke((Object)func, (String)WRITE_REPLACE, (Object[])new Object[0]);
            SERIALIZED_LAMBDA_CACHE.put(func.getClass().getName(), new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static <T> Consumer<T> doNothing() {
        return t -> {};
    }

    public static <T, R> Function<T, R> alwaysNull() {
        return t -> null;
    }

    public static <T, R> Function<T, R> always(R defaultValue) {
        return t -> defaultValue;
    }
}

