/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.container;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;

public abstract class BaseKeyContainer<K>
implements Container {
    private static final Logger log = LoggerFactory.getLogger(BaseKeyContainer.class);
    protected final Class<K> keyType;

    protected BaseKeyContainer() {
        this.keyType = this.getKeyType();
    }

    @Override
    public void process(Multimap<AssembleOperation, ?> operations) {
        if (Objects.isNull(operations) || operations.isEmpty()) {
            return;
        }
        Set<K> keys = this.getTargetIds(operations);
        if (CollUtil.isEmpty(keys)) {
            return;
        }
        Map sources = ObjectUtils.trySupply(() -> this.getSources(keys), x -> {
            log.warn("\u5bb9\u5668[{}]\u83b7\u53d6\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff0ckey[{}]", this.getClass(), (Object)keys);
            x.printStackTrace();
        });
        if (CollUtil.isEmpty((Map)sources)) {
            return;
        }
        operations.forEach((op, t) -> this.writeToTargets(sources, t, (AssembleOperation)op));
    }

    protected void writeToTargets(@Nonnull Map<K, ?> sources, @Nullable Object target, @Nonnull AssembleOperation operation) {
        if (Objects.isNull(target)) {
            return;
        }
        Object key = operation.getAssembler().getKey(target, operation);
        Object source = sources.get(this.parseKey(key));
        if (Objects.nonNull(source)) {
            ObjectUtils.tryAction(() -> operation.getAssembler().execute(target, source, operation), x -> log.error("\u5b57\u6bb5[{}]\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)operation.getTargetProperty(), (Object)x.getMessage()));
        }
    }

    @Nonnull
    protected abstract Map<K, ?> getSources(@Nonnull Set<K> var1);

    @Nonnull
    protected Set<K> getTargetIds(@Nonnull Multimap<AssembleOperation, ?> operations) {
        HashSet results = new HashSet();
        operations.forEach((op, t) -> {
            Object key = op.getAssembler().getKey(t, (AssembleOperation)op);
            K actualKey = this.parseKey(key);
            if (Objects.nonNull(actualKey)) {
                results.add(actualKey);
            }
        });
        return results;
    }

    protected Class<K> getKeyType() {
        return ClassUtil.getTypeArgument(this.getClass());
    }

    @Nullable
    protected K parseKey(@Nullable Object key) {
        return (K)Convert.convert(this.keyType, (Object)key);
    }

    public BaseKeyContainer(Class<K> keyType) {
        this.keyType = keyType;
    }
}

