/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.container;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.google.common.collect.Multimap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.annotation.MappingType;
import top.xiajibagao.crane.core.annotation.MethodSourceBean;
import top.xiajibagao.crane.core.container.BaseNamespaceContainer;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.invoker.MethodInvoker;
import top.xiajibagao.crane.core.helper.property.BeanProperty;
import top.xiajibagao.crane.core.helper.property.BeanPropertyFactory;
import top.xiajibagao.crane.core.helper.reflex.AsmReflexUtils;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class MethodSourceContainer
extends BaseNamespaceContainer<Object, Object>
implements Container {
    private static final Logger log = LoggerFactory.getLogger(MethodSourceContainer.class);
    public final Map<String, MethodSource> methodCache = new HashMap<String, MethodSource>();
    private final BeanPropertyFactory beanPropertyFactory;

    public void unregister(String namespace) {
        this.methodCache.remove(namespace);
    }

    public void register(Object methodSourceBean) {
        if (Objects.isNull(methodSourceBean)) {
            return;
        }
        Class<?> targetClass = methodSourceBean.getClass();
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations(targetClass, MethodSourceBean.class);
        if (CollUtil.isEmpty((Collection)annotations)) {
            return;
        }
        this.parseClassAnnotation(methodSourceBean, targetClass, annotations);
        this.parseMethodAnnotations(methodSourceBean, targetClass);
    }

    public void registerMethod(Object target, Method targetMethod, String namespace, Class<?> sourceType, String sourceKey, MappingType mappingType) {
        Assert.notNull((Object)target, (String)"target must not null");
        Assert.notNull((Object)targetMethod, (String)"targetMethod must not null");
        Assert.notNull((Object)namespace, (String)"namespace must not null");
        Assert.notNull(sourceType, (String)"sourceType must not null");
        Assert.notNull((Object)sourceKey, (String)"sourceKey must not null");
        Assert.notNull((Object)((Object)mappingType), (String)"mappingType must not null");
        Class<?> targetClass = target.getClass();
        this.registerMethodSource(target, targetClass, targetMethod, namespace, sourceType, sourceKey, mappingType);
    }

    private void parseClassAnnotation(Object methodSourceBean, Class<?> targetClass, Set<MethodSourceBean> annotations) {
        annotations.stream().map(MethodSourceBean::value).flatMap(Stream::of).filter(annotation -> CharSequenceUtil.isNotBlank((CharSequence)annotation.name())).forEach(annotation -> {
            Method method = ReflexUtils.findMethod(targetClass, annotation.name(), true, annotation.returnType(), annotation.paramTypes());
            if (Objects.nonNull(method)) {
                this.registerMethodFromAnnotation(methodSourceBean, targetClass, (MethodSourceBean.Method)annotation, method);
            }
        });
    }

    private void parseMethodAnnotations(Object methodSourceBean, Class<?> targetClass) {
        List<Method> annotatedMethods = Stream.of(targetClass.getDeclaredMethods()).filter(m -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, MethodSourceBean.Method.class)).collect(Collectors.toList());
        annotatedMethods.forEach(proxyMethod -> {
            Method actualMethod = AopUtils.getMostSpecificMethod((Method)proxyMethod, (Class)targetClass);
            MethodSourceBean.Method annotation = (MethodSourceBean.Method)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)actualMethod, MethodSourceBean.Method.class);
            if (Objects.isNull(annotation)) {
                return;
            }
            this.registerMethodFromAnnotation(methodSourceBean, targetClass, annotation, (Method)proxyMethod);
        });
    }

    private void registerMethodFromAnnotation(Object target, Class<?> targetClass, MethodSourceBean.Method annotation, Method method) {
        this.registerMethodSource(target, targetClass, method, annotation.namespace(), annotation.sourceType(), annotation.sourceKey(), annotation.mappingType());
    }

    private void registerMethodSource(Object target, Class<?> targetClass, Method targetMethod, String namespace, Class<?> sourceType, String sourceKey, MappingType mappingType) {
        this.checkMethod(targetMethod, namespace);
        this.beanPropertyFactory.getProperty(sourceType, sourceKey).ifPresent(property -> {
            MethodSource cache = new MethodSource(mappingType, target, targetClass, namespace, AsmReflexUtils.findMethod(targetClass, targetMethod, true), (BeanProperty)property, targetMethod.getParameterTypes().length == 0);
            this.methodCache.put(namespace, cache);
            log.info("\u6ce8\u518c\u6570\u636e\u6e90\u65b9\u6cd5[{}]: {}, \u6620\u5c04\u7c7b\u578b\uff1a[{}]", new Object[]{namespace, targetMethod.getName(), mappingType.name()});
        });
    }

    private void checkMethod(Method declaredMethod, String containerName) {
        Assert.isTrue((!this.methodCache.containsKey(containerName) ? 1 : 0) != 0, (String)("\u5bb9\u5668\u65b9\u6cd5\u5df2\u7ecf\u88ab\u6ce8\u518c: " + containerName));
        Assert.isTrue((declaredMethod.getParameterTypes().length == 0 || declaredMethod.getParameterTypes().length == 1 && ClassUtils.isAssignable(Collection.class, declaredMethod.getParameterTypes()[0]) ? 1 : 0) != 0, (String)("\u5bb9\u5668\u65b9\u6cd5\u6700\u591a\u4ec5\u80fd\u6709\u4e00\u4e2aCollection\u7c7b\u578b\u7684\u53c2\u6570: " + Arrays.asList(declaredMethod.getParameterTypes())));
        Assert.isTrue((boolean)ClassUtils.isAssignable(Collection.class, declaredMethod.getReturnType()), (String)("\u5bb9\u5668\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aCollection\u7c7b\u578b: " + declaredMethod.getReturnType()));
    }

    @Override
    @Nonnull
    protected Map<String, Map<Object, Object>> getSources(@Nonnull Multimap<String, Object> namespaceAndKeys) {
        HashMap<String, Map<Object, Object>> results = new HashMap<String, Map<Object, Object>>(namespaceAndKeys.size());
        namespaceAndKeys.asMap().forEach((namespace, keys) -> {
            MethodSource method = this.methodCache.get(namespace);
            if (Objects.isNull(method)) {
                return;
            }
            Collection<Object> sources = method.getSources((Collection<Object>)keys);
            if (CollUtil.isEmpty(sources)) {
                return;
            }
            results.put((String)namespace, method.getMappingType().mapping(sources, method::getSourceKeyPropertyValue));
        });
        return results;
    }

    public MethodSourceContainer(BeanPropertyFactory beanPropertyFactory) {
        this.beanPropertyFactory = beanPropertyFactory;
    }

    public static class MethodSource {
        private final MappingType mappingType;
        private final Object target;
        private final Class<?> targetClass;
        private final String containerName;
        private final MethodInvoker methodInvoker;
        private final BeanProperty sourceKeyProperty;
        private final boolean isNotArgMethod;

        public Collection<Object> getSources(Collection<Object> keys) {
            Object result = this.isNotArgMethod ? this.methodInvoker.invoke(this.target, new Object[0]) : this.methodInvoker.invoke(this.target, keys);
            return (Collection)result;
        }

        public Object getSourceKeyPropertyValue(Object source) {
            return this.sourceKeyProperty.getValue(source);
        }

        public MethodSource(MappingType mappingType, Object target, Class<?> targetClass, String containerName, MethodInvoker methodInvoker, BeanProperty sourceKeyProperty, boolean isNotArgMethod) {
            this.mappingType = mappingType;
            this.target = target;
            this.targetClass = targetClass;
            this.containerName = containerName;
            this.methodInvoker = methodInvoker;
            this.sourceKeyProperty = sourceKeyProperty;
            this.isNotArgMethod = isNotArgMethod;
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }
}

