/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.executor;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.MultiValueTableMap;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public abstract class AbstractOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration, @Nonnull Set<Class<?>> groups) {
        if (CollUtil.isEmpty(targets) || Objects.isNull(configuration) || CollUtil.isEmpty(groups)) {
            return;
        }
        List<Object> targetsList = StreamSupport.stream(targets.spliterator(), false).collect(Collectors.toList());
        MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations = new MultiValueTableMap<Container, AssembleOperation, Object>();
        this.collectOperations(targetsList, configuration, groups, pendingOperations);
        this.execute(configuration.getGlobalConfiguration(), pendingOperations);
    }

    private void collectOperations(Collection<Object> targets, OperationConfiguration configuration, Set<Class<?>> targetGroups, MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        if (CollectionUtils.isEmpty(targets)) {
            return;
        }
        this.processAssembleOperations(targets, configuration, targetGroups, pendingOperations);
        this.processDisassembleOperations(targets, configuration, targetGroups, pendingOperations);
    }

    protected abstract void execute(@Nonnull GlobalConfiguration var1, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> var2);

    protected void processAssembleOperations(@Nonnull Collection<Object> targets, @Nonnull OperationConfiguration configuration, Set<Class<?>> targetGroups, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        List<AssembleOperation> operations = configuration.getAssembleOperations();
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        operations.stream().filter(op -> CollUtil.containsAny((Collection)targetGroups, op.getGroups())).forEach(op -> pendingOperations.putValAll(op.getContainer(), (AssembleOperation)op, targets));
    }

    protected void processDisassembleOperations(@Nonnull Collection<?> targets, @Nonnull OperationConfiguration configuration, Set<Class<?>> targetGroups, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            DisassembleOperation.collect(operation, targets).asMap().forEach((config, values) -> this.collectOperations((Collection<Object>)values, (OperationConfiguration)config, targetGroups, pendingOperations));
        }
    }
}

