/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.collection.CollUtil;
import java.util.Map;
import top.xiajibagao.crane.core.annotation.ProcessorComponent;
import top.xiajibagao.crane.core.handler.AbstractOperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

@ProcessorComponent(value={"JAVA_BEAN"})
public class MapOperateHandler
extends AbstractOperateHandler
implements OperateHandler {
    public MapOperateHandler(OperateProcessor operateProcessor, String ... defaultRegisterGroups) {
        super(operateProcessor, defaultRegisterGroups);
    }

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return source instanceof Map;
    }

    @Override
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        Map<String, Object> sourceMap = this.parseMap(source);
        if (CollUtil.isEmpty(sourceMap)) {
            return null;
        }
        return property.hasResource() ? sourceMap.get(property.getSource()) : sourceMap;
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return target instanceof Map;
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        Map<String, Object> targetMap = this.parseMap(target);
        if (CollUtil.isEmpty(targetMap)) {
            return;
        }
        if (!property.hasReference()) {
            targetMap.put(operation.getTargetProperty().getName(), sourceData);
            return;
        }
        targetMap.put(property.getReference(), sourceData);
    }

    private Map<String, Object> parseMap(Object data) {
        return (Map)data;
    }
}

