/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.core.annotation.ConfigOption;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.BeanFactoryUtils;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class ConfigOptionAnnotationProcessor<T extends AnnotatedElement> {
    private final BeanFactory beanFactory;
    private final ConfigurationCache configurationCache;

    public void process(T annotatedElement, Object target) {
        if (Objects.isNull(target)) {
            return;
        }
        ConfigOption annotation = this.parseAnnotation((AnnotatedElement)annotatedElement);
        if (Objects.isNull(annotation) || ArrayUtil.isEmpty((Object[])annotation.groups())) {
            return;
        }
        Class<Void> targetClass = this.getTargetClass(annotation, annotatedElement, target);
        if (Objects.isNull(targetClass) || targetClass.isAssignableFrom(Void.TYPE)) {
            return;
        }
        OperateConfigurationParser parser = BeanFactoryUtils.getBean(this.beanFactory, annotation.parser(), annotation.parserName());
        OperationConfiguration configuration = this.configurationCache.getOrCached(this.getNamespace(parser), targetClass, parser::parse);
        OperationExecutor executor = BeanFactoryUtils.getBean(this.beanFactory, annotation.executor(), annotation.executorName());
        executor.execute(CollUtils.adaptToCollection(target), configuration, annotation.groups());
    }

    protected String getNamespace(OperateConfigurationParser parser) {
        return parser.getClass().getName();
    }

    protected ConfigOption parseAnnotation(AnnotatedElement annotatedElement) {
        return Objects.isNull(annotatedElement) ? null : (ConfigOption)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, ConfigOption.class);
    }

    protected Class<?> getTargetClass(ConfigOption annotation, T annotatedElement, Object target) {
        return Objects.equals(annotation.value(), Void.TYPE) ? ObjectUtils.getClass(target) : annotation.value();
    }

    public ConfigOptionAnnotationProcessor(BeanFactory beanFactory, ConfigurationCache configurationCache) {
        this.beanFactory = beanFactory;
        this.configurationCache = configurationCache;
    }
}

