/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.util.Collection;
import java.util.Objects;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class OperateTemplate {
    private final ConfigurationCache configurationCache;
    private final OperateConfigurationParser defaultOperateConfigurationParser;
    private final OperationExecutor defaultOperationExecutor;

    public void process(Object target, OperationConfiguration configuration, Class<?> ... groups) {
        this.process(target, configuration, this.defaultOperationExecutor, groups);
    }

    public void process(Object target, OperationConfiguration configuration, OperationExecutor executor, Class<?> ... groups) {
        executor.execute(CollUtils.adaptToCollection(target), configuration, groups);
    }

    public void process(Object target, OperateConfigurationParser parser, OperationExecutor executor, Class<?> ... groups) {
        Collection<?> targets = CollUtils.adaptToCollection(target);
        Class<?> targetClass = ObjectUtils.getClass(target);
        if (Objects.isNull(targetClass)) {
            return;
        }
        OperationConfiguration configuration = this.configurationCache.getOrCached(parser.getClass().getName(), targetClass, parser::parse);
        executor.execute(targets, configuration, groups);
    }

    public void process(Object target, OperateConfigurationParser parser, Class<?> ... groups) {
        this.process(target, parser, this.defaultOperationExecutor, groups);
    }

    public void process(Object target, OperationExecutor executor, Class<?> ... groups) {
        this.process(target, this.defaultOperateConfigurationParser, executor, groups);
    }

    public void process(Object target, Class<?> ... groups) {
        this.process(target, this.defaultOperateConfigurationParser, this.defaultOperationExecutor, groups);
    }

    public OperateTemplate(ConfigurationCache configurationCache, OperateConfigurationParser defaultOperateConfigurationParser, OperationExecutor defaultOperationExecutor) {
        this.configurationCache = configurationCache;
        this.defaultOperateConfigurationParser = defaultOperateConfigurationParser;
        this.defaultOperationExecutor = defaultOperationExecutor;
    }
}

