/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper.reflex;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import top.xiajibagao.crane.core.helper.invoker.AsmReflexMethodInvoker;
import top.xiajibagao.crane.core.helper.invoker.MethodInvoker;
import top.xiajibagao.crane.core.helper.invoker.ParamTypeAutoConvertInvoker;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;

public class AsmReflexUtils {
    private static final Map<Class<?>, MethodAccess> METHOD_ACCESS_CACHE = new ConcurrentHashMap();

    private AsmReflexUtils() {
    }

    public static int findSetterMethodIndex(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        Method setter = ReflexUtils.findSetterMethod(targetClass, fieldName, fieldType);
        return Objects.isNull(setter) ? -1 : methodAccess.getIndex(setter.getName(), (Class[])setter.getParameterTypes());
    }

    public static int findGetterMethodIndex(Class<?> targetClass, String fieldName) {
        MethodAccess methodAccess = AsmReflexUtils.getMethodAccess(targetClass);
        Method getter = ReflexUtils.findGetterMethod(targetClass, fieldName);
        return Objects.isNull(getter) ? -1 : methodAccess.getIndex(getter.getName(), (Class[])getter.getParameterTypes());
    }

    public static MethodAccess getMethodAccess(Class<?> targetClass) {
        return METHOD_ACCESS_CACHE.computeIfAbsent(targetClass, MethodAccess::get);
    }

    public static MethodInvoker findMethod(Class<?> targetClass, Method method, boolean enableParamTypeConvert) {
        MethodAccess methodAccess = MethodAccess.get(targetClass);
        AsmReflexMethodInvoker methodInvoker = new AsmReflexMethodInvoker(methodAccess, methodAccess.getIndex(method.getName(), (Class[])method.getParameterTypes()));
        return enableParamTypeConvert ? new ParamTypeAutoConvertInvoker(method.getParameterTypes(), methodInvoker) : methodInvoker;
    }

    public static MethodInvoker findMethod(Class<?> targetClass, Method method) {
        return AsmReflexUtils.findMethod(targetClass, method, false);
    }
}

