/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.interceptor;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.crane.core.annotation.ProcessorComponent;
import top.xiajibagao.crane.core.helper.ExpressionUtils;
import top.xiajibagao.crane.core.operator.OperateProcessorComponentSign;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessorComponent;
import top.xiajibagao.crane.core.operator.interfaces.TargetWriteInterceptor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

@ProcessorComponent
public class ExpressionPreprocessingInterceptor
implements TargetWriteInterceptor,
OperateProcessorComponent {
    private ContextFactory contextFactory;
    private final OperateProcessorComponentSign operateProcessorComponentSign;

    public ExpressionPreprocessingInterceptor(@Nonnull ContextFactory contextFactory, String ... defaultRegisterGroups) {
        Objects.requireNonNull(contextFactory);
        this.contextFactory = contextFactory;
        this.operateProcessorComponentSign = new OperateProcessorComponentSign(this.getClass(), defaultRegisterGroups);
    }

    @Override
    public String[] getRegisterGroups() {
        return this.operateProcessorComponentSign.getRegisterGroups();
    }

    @Override
    public boolean isRegistrable(OperateProcessorComponent registrable) {
        return this.operateProcessorComponentSign.isRegistrable(registrable);
    }

    public ExpressionPreprocessingInterceptor setContextFactory(@Nonnull ContextFactory contextFactory) {
        Objects.requireNonNull(contextFactory);
        this.contextFactory = contextFactory;
        return this;
    }

    @Override
    public boolean supportInterceptSourceWrite(@Nullable Object sourceData, @Nullable Object target, PropertyMapping property, AssembleOperation operation) {
        return CharSequenceUtil.isNotBlank((CharSequence)property.getExp());
    }

    @Override
    public Object interceptSourceWrite(@Nullable Object sourceData, @Nullable Object target, PropertyMapping property, AssembleOperation operation) {
        Context context = new Context(sourceData, target, property, operation);
        EvaluationContext evaluationContext = this.contextFactory.get(context);
        return ExpressionUtils.execute(property.getExp(), evaluationContext, property.getExpType(), true);
    }

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public static class DefaultContextFactory
    implements ContextFactory {
        private final List<Consumer<StandardEvaluationContext>> appendAction = new ArrayList<Consumer<StandardEvaluationContext>>();

        public DefaultContextFactory addAction(@Nonnull Consumer<StandardEvaluationContext> action) {
            this.appendAction.add(action);
            return this;
        }

        public StandardEvaluationContext get(Context sourceWriteOperationContext) {
            Object sourceData = sourceWriteOperationContext.getSourceData();
            Object target = sourceWriteOperationContext.getTarget();
            PropertyMapping property = sourceWriteOperationContext.getProperty();
            AssembleOperation operation = sourceWriteOperationContext.getOperation();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("target", target);
            context.setVariable("source", sourceData);
            context.setVariable("key", operation.getAssembler().getKey(target, operation));
            context.setVariable("src", (Object)property.getSource());
            context.setVariable("ref", (Object)property.getReference());
            context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            this.appendAction.forEach(action -> action.accept(context));
            return context;
        }
    }

    public static class Context {
        private final Object sourceData;
        private final Object target;
        private final PropertyMapping property;
        private final AssembleOperation operation;

        public Object getSourceData() {
            return this.sourceData;
        }

        public Object getTarget() {
            return this.target;
        }

        public PropertyMapping getProperty() {
            return this.property;
        }

        public AssembleOperation getOperation() {
            return this.operation;
        }

        public Context(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
            this.sourceData = sourceData;
            this.target = target;
            this.property = property;
            this.operation = operation;
        }
    }

    @FunctionalInterface
    public static interface ContextFactory {
        public EvaluationContext get(Context var1);
    }
}

