/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.operator;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.aop.framework.AopProxyUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.helper.Orderly;
import top.xiajibagao.crane.core.operator.OperateProcessorComponentSign;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessorComponent;
import top.xiajibagao.crane.core.operator.interfaces.SourceReadInterceptor;
import top.xiajibagao.crane.core.operator.interfaces.SourceReader;
import top.xiajibagao.crane.core.operator.interfaces.TargetWriteInterceptor;
import top.xiajibagao.crane.core.operator.interfaces.TargetWriter;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;

public abstract class AbstractOperateProcessor<T extends AbstractOperateProcessor<T>>
implements OperateProcessor {
    private final List<TargetWriter> targetWriters = new ArrayList<TargetWriter>();
    private final List<TargetWriteInterceptor> targetWriteInterceptors = new ArrayList<TargetWriteInterceptor>();
    private final List<SourceReader> sourceReaders = new ArrayList<SourceReader>();
    private final List<SourceReadInterceptor> sourceReadInterceptors = new ArrayList<SourceReadInterceptor>();
    protected final OperateProcessorComponentSign operateProcessorComponentSign;
    private final T typedThis = this;

    protected AbstractOperateProcessor(String ... defaultRegisterGroups) {
        this.operateProcessorComponentSign = new OperateProcessorComponentSign(this.getClass(), defaultRegisterGroups);
    }

    @Override
    public String[] getRegisterGroups() {
        return this.operateProcessorComponentSign.getRegisterGroups();
    }

    @Override
    public boolean isRegistrable(OperateProcessorComponent registrable) {
        return this.operateProcessorComponentSign.isRegistrable(registrable);
    }

    public T registerTargetWriters(TargetWriter ... targetWriters) {
        return (T)this.register(this.targetWriters, targetWriters);
    }

    public T registerTargetWriteInterceptors(TargetWriteInterceptor ... targetWriteInterceptors) {
        return (T)this.register(this.targetWriteInterceptors, targetWriteInterceptors);
    }

    public T registerSourceReaders(SourceReader ... sourceReaders) {
        return (T)this.register(this.sourceReaders, sourceReaders);
    }

    public T registerSourceReadInterceptors(SourceReadInterceptor ... sourceReadInterceptors) {
        return (T)this.register(this.sourceReadInterceptors, sourceReadInterceptors);
    }

    public T registerHandlers(OperateHandler ... operateHandler) {
        this.registerTargetWriters(operateHandler);
        this.registerSourceReaders(operateHandler);
        return this.typedThis;
    }

    public T registerComponents(OperateProcessorComponent ... operateProcessorComponent) {
        for (OperateProcessorComponent registrable : operateProcessorComponent) {
            if (registrable instanceof TargetWriter) {
                this.registerTargetWriters(new TargetWriter[]{(TargetWriter)registrable});
                continue;
            }
            if (registrable instanceof SourceReader) {
                this.registerSourceReaders(new SourceReader[]{(SourceReader)registrable});
                continue;
            }
            if (registrable instanceof TargetWriteInterceptor) {
                this.registerTargetWriteInterceptors(new TargetWriteInterceptor[]{(TargetWriteInterceptor)registrable});
                continue;
            }
            if (!(registrable instanceof SourceReadInterceptor)) continue;
            this.registerSourceReadInterceptors(new SourceReadInterceptor[]{(SourceReadInterceptor)registrable});
        }
        return this.typedThis;
    }

    @SafeVarargs
    protected final <I extends Orderly & OperateProcessorComponent> T register(List<I> list, I ... items) {
        if (ArrayUtil.isEmpty((Object[])items)) {
            return this.typedThis;
        }
        Stream.of(items).filter(x$0 -> Objects.nonNull(x$0)).filter(t -> !list.contains(t)).filter(t -> !ClassUtil.isAssignable(OperateProcessor.class, (Class)AopProxyUtils.ultimateTargetClass((Object)t))).filter(x$0 -> this.isRegistrable((OperateProcessorComponent)x$0)).forEach(x$0 -> list.add(x$0));
        list.sort(Orderly.comparator());
        return this.typedThis;
    }

    @Override
    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return this.getSourceReaders().stream().anyMatch(h -> h.sourceCanRead(source, property, operation));
    }

    @Override
    @Nullable
    public Object readFromSource(Object source, PropertyMapping property, Operation operation) {
        for (SourceReadInterceptor interceptor : this.getSourceReadInterceptors()) {
            if (!interceptor.supportInterceptReadSource(source, property, operation)) continue;
            source = interceptor.interceptReadSource(source, property, operation);
        }
        Object interceptedSources = source;
        return this.getSourceReaders().stream().filter(h -> h.sourceCanRead(interceptedSources, property, operation)).findFirst().map(h -> h.readFromSource(interceptedSources, property, operation)).orElse(null);
    }

    @Override
    @Nullable
    public Object tryReadFromSource(Object source, PropertyMapping property, Operation operation) {
        return this.sourceCanRead(source, property, operation) ? this.readFromSource(source, property, operation) : null;
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return this.getTargetWriters().stream().anyMatch(h -> h.targetCanWrite(sourceData, target, property, operation));
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        for (TargetWriteInterceptor interceptor : this.getTargetWriteInterceptors()) {
            if (!interceptor.supportInterceptSourceWrite(sourceData, target, property, operation)) continue;
            sourceData = interceptor.interceptSourceWrite(sourceData, target, property, operation);
        }
        Object interceptedSourcesData = sourceData;
        this.getTargetWriters().stream().filter(h -> h.targetCanWrite(interceptedSourcesData, target, property, operation)).findFirst().ifPresent(h -> h.writeToTarget(interceptedSourcesData, target, property, operation));
    }

    @Override
    public void tryWriteToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        if (this.targetCanWrite(sourceData, target, property, operation)) {
            this.writeToTarget(sourceData, target, property, operation);
        }
    }

    @Override
    public List<TargetWriter> getTargetWriters() {
        return this.targetWriters;
    }

    @Override
    public List<TargetWriteInterceptor> getTargetWriteInterceptors() {
        return this.targetWriteInterceptors;
    }

    @Override
    public List<SourceReader> getSourceReaders() {
        return this.sourceReaders;
    }

    @Override
    public List<SourceReadInterceptor> getSourceReadInterceptors() {
        return this.sourceReadInterceptors;
    }

    public OperateProcessorComponentSign getOperateProcessorComponentSign() {
        return this.operateProcessorComponentSign;
    }

    public T getTypedThis() {
        return this.typedThis;
    }
}

