/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.parser.BeanDisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DynamicDisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class BeanDynamicDisassembleOperation
implements DynamicDisassembleOperation {
    private final OperateConfigurationParser configurationParser;
    private final int order;
    private final OperationConfiguration owner;
    private final Disassembler disassembler;
    private final Field targetProperty;
    private final Set<String> targetPropertyAliases;
    private final ConfigurationCache configurationCache;

    @Override
    @Nullable
    public OperationConfiguration getTargetOperateConfiguration(Object target) {
        Class<?> targetClass = this.getTargetClass(target);
        return this.configurationCache.getOrCached(this.configurationParser.getClass().getName(), targetClass, this.configurationParser::parse);
    }

    @Override
    @Nullable
    public DisassembleOperation resolve(Object target) {
        OperationConfiguration operation = this.getTargetOperateConfiguration(target);
        return Objects.isNull(operation) ? null : new BeanDisassembleOperation(this.order, this.owner, this.disassembler, operation, this.targetProperty, this.targetPropertyAliases);
    }

    @Nullable
    private Class<?> getTargetClass(Object target) {
        if (Objects.isNull(target)) {
            return null;
        }
        Class<?> targetClass = null;
        LinkedList deque = CollUtil.newLinkedList((Object[])new Object[]{target});
        while (!deque.isEmpty()) {
            Object targetObj = deque.removeFirst();
            if (Objects.isNull(targetObj)) continue;
            targetClass = targetObj.getClass();
            if (!(targetObj instanceof Collection) && !targetClass.isArray()) break;
            CollUtil.addAll((Collection)deque, targetObj);
        }
        return targetClass;
    }

    public BeanDynamicDisassembleOperation(OperateConfigurationParser configurationParser, int order, OperationConfiguration owner, Disassembler disassembler, Field targetProperty, Set<String> targetPropertyAliases, ConfigurationCache configurationCache) {
        this.configurationParser = configurationParser;
        this.order = order;
        this.owner = owner;
        this.disassembler = disassembler;
        this.targetProperty = targetProperty;
        this.targetPropertyAliases = targetPropertyAliases;
        this.configurationCache = configurationCache;
    }

    public OperateConfigurationParser getConfigurationParser() {
        return this.configurationParser;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public OperationConfiguration getOwner() {
        return this.owner;
    }

    @Override
    public Disassembler getDisassembler() {
        return this.disassembler;
    }

    @Override
    public Field getTargetProperty() {
        return this.targetProperty;
    }

    @Override
    public Set<String> getTargetPropertyAliases() {
        return this.targetPropertyAliases;
    }

    public ConfigurationCache getConfigurationCache() {
        return this.configurationCache;
    }
}

