/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser.interfaces;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.parser.interfaces.DynamicDisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public interface DisassembleOperation
extends Operation {
    public OperationConfiguration getOwner();

    public Disassembler getDisassembler();

    public OperationConfiguration getTargetOperateConfiguration();

    public static boolean isDynamic(DisassembleOperation operation) {
        return operation instanceof DynamicDisassembleOperation;
    }

    public static Multimap<OperationConfiguration, Object> collect(DisassembleOperation disassembleOperation, Collection<?> targets) {
        boolean isDynamic = DisassembleOperation.isDynamic(disassembleOperation);
        ArrayListMultimap operationConfigurations = ArrayListMultimap.create();
        for (Object target : targets) {
            Collection<?> values;
            DisassembleOperation operation = isDynamic ? ((DynamicDisassembleOperation)disassembleOperation).resolve(target) : disassembleOperation;
            if (Objects.isNull(operation) || !CollUtil.isNotEmpty(values = operation.getDisassembler().execute(target, operation))) continue;
            operationConfigurations.putAll((Object)operation.getTargetOperateConfiguration(), values);
        }
        return operationConfigurations;
    }
}

