/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.extension.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import top.xiajibagao.crane.core.helper.ExpressionUtils;
import top.xiajibagao.crane.extension.aop.ProcessResult;
import top.xiajibagao.crane.extension.cache.ConfigurationCache;
import top.xiajibagao.crane.extension.helper.ConfigOptionAnnotationProcessor;

@Aspect
public class MethodResultProcessAspect
extends ConfigOptionAnnotationProcessor<Method> {
    private static final Logger log = LoggerFactory.getLogger(MethodResultProcessAspect.class);

    public MethodResultProcessAspect(BeanFactory beanFactory, ConfigurationCache configurationCache) {
        super(beanFactory, configurationCache);
    }

    @AfterReturning(returning="result", pointcut="@annotation(top.xiajibagao.crane.extension.aop.ProcessResult)")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        if (ObjectUtils.isEmpty((Object)result)) {
            return;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ProcessResult annotation = (ProcessResult)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ProcessResult.class);
        if (Objects.isNull(annotation)) {
            return;
        }
        String condition = annotation.condition();
        if (!StringUtils.hasText((String)condition)) {
            this.process(method, result);
            return;
        }
        Boolean isProcess = Boolean.TRUE;
        StandardEvaluationContext context = new StandardEvaluationContext();
        String[] paramNames = methodSignature.getParameterNames();
        Object[] params = joinPoint.getArgs();
        ExpressionUtils.registerMethodArgs(Arrays.asList(paramNames), Arrays.asList(params), (StandardEvaluationContext)context);
        context.setVariable("result", result);
        try {
            isProcess = (Boolean)ExpressionUtils.execute((String)condition, (EvaluationContext)context, Boolean.class, (boolean)true);
        }
        catch (Exception e) {
            log.warn("\u8868\u8fbe\u5f0f[{}]\u6267\u884c\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a[{}]", (Object)condition, (Object)e.getMessage());
        }
        if (Objects.nonNull(isProcess) && isProcess.booleanValue()) {
            this.process(method, result);
        }
    }
}

