/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.extension.cache;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.extension.cache.ConfigurationCache;

public class OperationConfigurationCache
implements ConfigurationCache {
    private final Map<String, Table<Class<? extends OperatorFactory>, Class<?>, OperationConfiguration>> parsedConfigurationCaches = new ConcurrentHashMap();
    private final Supplier<Table<Class<? extends OperatorFactory>, Class<?>, OperationConfiguration>> cacheFactory;

    public OperationConfigurationCache(Supplier<Table<Class<? extends OperatorFactory>, Class<?>, OperationConfiguration>> cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public OperationConfigurationCache() {
        this(() -> Tables.synchronizedTable((Table)HashBasedTable.create()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setConfigurationCache(String namespace, Class<? extends OperatorFactory> factoryType, Class<?> targetType, OperationConfiguration configuration) {
        Table cache = this.parsedConfigurationCaches.computeIfAbsent(namespace, ns -> this.cacheFactory.get());
        if (!cache.contains(factoryType, targetType)) {
            OperationConfigurationCache operationConfigurationCache = this;
            synchronized (operationConfigurationCache) {
                if (!cache.contains(factoryType, targetType)) {
                    cache.put(factoryType, targetType, (Object)configuration);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public OperationConfiguration getCachedConfiguration(String namespace, Class<? extends OperatorFactory> factoryType, Class<?> targetType) {
        return Optional.ofNullable(this.parsedConfigurationCaches.get(namespace)).map(cache -> (OperationConfiguration)cache.get((Object)factoryType, (Object)targetType)).orElse(null);
    }
}

