/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.extension.container;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.annotation.MappingType;
import top.xiajibagao.crane.core.helper.BeanProperty;

public class MethodSource {
    private final MappingType mappingType;
    private final Object target;
    private final Class<?> targetClass;
    private final String containerName;
    private final Method sourceGetter;
    private final BeanProperty sourceKeyProperty;

    public Collection<Object> getSources(List<Object> keys) {
        Collection<Object> params = keys;
        if (Objects.equals(this.sourceGetter.getParameterTypes()[0], Set.class)) {
            params = new HashSet<Object>(keys);
        }
        return (Collection)ReflectionUtils.invokeMethod((Method)this.sourceGetter, (Object)this.target, (Object[])new Object[]{params});
    }

    public Object getSourceKeyPropertyValue(Object source) {
        return ReflectionUtils.invokeMethod((Method)this.sourceKeyProperty.getter(), (Object)source);
    }

    public MethodSource(MappingType mappingType, Object target, Class<?> targetClass, String containerName, Method sourceGetter, BeanProperty sourceKeyProperty) {
        this.mappingType = mappingType;
        this.target = target;
        this.targetClass = targetClass;
        this.containerName = containerName;
        this.sourceGetter = sourceGetter;
        this.sourceKeyProperty = sourceKeyProperty;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getContainerName() {
        return this.containerName;
    }
}

