/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.extension.helper;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.annotation.ConfigOption;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.extension.cache.ConfigurationCache;

public class ConfigOptionAnnotationProcessor<T extends AnnotatedElement> {
    private final BeanFactory beanFactory;
    private final ConfigurationCache configurationCache;

    public void process(T annotatedElement, Object target) {
        ConfigOption annotation = this.parseAnnotation((AnnotatedElement)annotatedElement);
        if (Objects.isNull(annotation)) {
            return;
        }
        Class targetClass = annotation.value();
        if (targetClass.isAssignableFrom(Void.TYPE)) {
            return;
        }
        OperateConfigurationParser parser = (OperateConfigurationParser)this.beanFactory.getBean(annotation.parser());
        OperatorFactory operatorFactory = (OperatorFactory)this.beanFactory.getBean(annotation.operatorFactory());
        OperationConfiguration configuration = this.configurationCache.getOrCached(this.getNamespace((OperateConfigurationParser<OperationConfiguration>)parser), operatorFactory.getClass(), targetClass, () -> parser.parse(targetClass, operatorFactory));
        OperationExecutor executor = (OperationExecutor)this.beanFactory.getBean(annotation.executor());
        executor.execute((Iterable)CollUtils.adaptToCollection((Object)target), configuration);
    }

    protected String getNamespace(OperateConfigurationParser<OperationConfiguration> parser) {
        return parser.getClass().getName();
    }

    protected ConfigOption parseAnnotation(AnnotatedElement annotatedElement) {
        return Objects.isNull(annotatedElement) ? null : (ConfigOption)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, ConfigOption.class);
    }

    public ConfigOptionAnnotationProcessor(BeanFactory beanFactory, ConfigurationCache configurationCache) {
        this.beanFactory = beanFactory;
        this.configurationCache = configurationCache;
    }
}

