/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.module;

import cn.hutool.core.lang.Assert;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.annotation.ProcessJacksonNode;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeBeanSerializer;

public class DynamicJsonNodeModule
extends Module {
    private final BeanFactory beanFactory;
    private final ObjectMapper objectMapper;
    private final OperatorFactory defaultOperatorFactory;
    private final OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser;
    private final OperationExecutor defaultOperationExecutor;

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier((BeanSerializerModifier)new DynamicJsonNodeBeanSerializerModifier(this.beanFactory, this.objectMapper, this.defaultOperatorFactory, this.defaultOperateConfigurationParser, this.defaultOperationExecutor));
    }

    public DynamicJsonNodeModule(BeanFactory beanFactory, ObjectMapper objectMapper, OperatorFactory defaultOperatorFactory, OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser, OperationExecutor defaultOperationExecutor) {
        this.beanFactory = beanFactory;
        this.objectMapper = objectMapper;
        this.defaultOperatorFactory = defaultOperatorFactory;
        this.defaultOperateConfigurationParser = defaultOperateConfigurationParser;
        this.defaultOperationExecutor = defaultOperationExecutor;
    }

    private static class DynamicJsonNodeBeanSerializerModifier
    extends BeanSerializerModifier {
        private final BeanFactory beanFactory;
        private final ObjectMapper objectMapper;
        private final OperatorFactory defaultOperatorFactory;
        private final OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser;
        private final OperationExecutor defaultOperationExecutor;

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            ProcessJacksonNode annotation = (ProcessJacksonNode)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanDesc.getBeanClass(), ProcessJacksonNode.class);
            if (Objects.isNull(annotation)) {
                return serializer;
            }
            OperatorFactory operatorFactory = this.defaultIfVoid(OperatorFactory.class, annotation.operatorFactory(), this.defaultOperatorFactory);
            OperateConfigurationParser<? extends OperationConfiguration> configurationParser = this.defaultIfVoid(OperateConfigurationParser.class, annotation.parser(), this.defaultOperateConfigurationParser);
            OperationConfiguration operationConfiguration = configurationParser.parse(beanDesc.getBeanClass(), operatorFactory);
            OperationExecutor operationExecutor = this.defaultIfVoid(OperationExecutor.class, annotation.executor(), this.defaultOperationExecutor);
            return new DynamicJsonNodeBeanSerializer(beanDesc.getBeanClass(), this.objectMapper, operationConfiguration, operationExecutor);
        }

        private <T> T defaultIfVoid(Class<T> targetType, Class<?> beanType, T def) {
            if (Objects.equals(Void.class, beanType)) {
                return def;
            }
            Assert.isAssignable(targetType, beanType, (String)"\u7c7b\u578b[{}]\u4e0d\u4e3a[{}]\u6216\u5176\u5b50\u7c7b", (Object[])new Object[]{targetType, beanType});
            return (T)(Objects.equals(Void.class, beanType) ? def : this.beanFactory.getBean(beanType));
        }

        public DynamicJsonNodeBeanSerializerModifier(BeanFactory beanFactory, ObjectMapper objectMapper, OperatorFactory defaultOperatorFactory, OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser, OperationExecutor defaultOperationExecutor) {
            this.beanFactory = beanFactory;
            this.objectMapper = objectMapper;
            this.defaultOperatorFactory = defaultOperatorFactory;
            this.defaultOperateConfigurationParser = defaultOperateConfigurationParser;
            this.defaultOperationExecutor = defaultOperationExecutor;
        }
    }
}

