/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.module;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.jackson.impl.annotation.ProcessJacksonNode;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeBeanSerializer;

public class DynamicJsonNodeModule
extends Module {
    private final BeanFactory beanFactory;
    private final ObjectMapper objectMapper;

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier((BeanSerializerModifier)new DynamicJsonNodeBeanSerializerModifier(this.beanFactory, this.objectMapper));
    }

    public DynamicJsonNodeModule(BeanFactory beanFactory, ObjectMapper objectMapper) {
        this.beanFactory = beanFactory;
        this.objectMapper = objectMapper;
    }

    private static class DynamicJsonNodeBeanSerializerModifier
    extends BeanSerializerModifier {
        private final BeanFactory beanFactory;
        private final ObjectMapper objectMapper;

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            ProcessJacksonNode annotation = (ProcessJacksonNode)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanDesc.getBeanClass(), ProcessJacksonNode.class);
            if (Objects.isNull(annotation)) {
                return serializer;
            }
            OperatorFactory operatorFactory = (OperatorFactory)this.beanFactory.getBean(annotation.operatorFactory());
            OperateConfigurationParser configurationParser = (OperateConfigurationParser)this.beanFactory.getBean(annotation.parser());
            OperationConfiguration operationConfiguration = configurationParser.parse(beanDesc.getBeanClass(), operatorFactory);
            OperationExecutor operationExecutor = (OperationExecutor)this.beanFactory.getBean(annotation.executor());
            return new DynamicJsonNodeBeanSerializer(beanDesc.getBeanClass(), this.objectMapper, operationConfiguration, operationExecutor);
        }

        public DynamicJsonNodeBeanSerializerModifier(BeanFactory beanFactory, ObjectMapper objectMapper) {
            this.beanFactory = beanFactory;
            this.objectMapper = objectMapper;
        }
    }
}

