/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.operator;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class JacksonDisassembler
implements Disassembler {
    private final ObjectMapper objectMapper;

    public Collection<?> execute(Object target, DisassembleOperation operation) {
        if (!(target instanceof JsonNode) || ((JsonNode)target).isNull()) {
            return Collections.emptyList();
        }
        JsonNode targetNode = (JsonNode)target;
        JsonNode targetPropertyNode = this.findTargetPropertyNode(targetNode, operation);
        if (JacksonUtils.isNull(targetPropertyNode)) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> results = new ArrayList<JsonNode>();
        if (targetPropertyNode.isArray()) {
            targetPropertyNode.forEach(results::add);
        } else if (targetPropertyNode.isObject()) {
            results.add(targetPropertyNode);
        } else {
            CraneException.throwOf((String)"\u5bf9\u8c61[{}]\u7684\u8282\u70b9[{}]\uff0c\u65e0\u6cd5\u62c6\u5378\u4e3ajson\u6570\u7ec4\u6216json\u5bf9\u8c61", (Object[])new Object[]{targetNode, targetPropertyNode});
        }
        return results;
    }

    protected JsonNode findTargetPropertyNode(JsonNode target, DisassembleOperation operation) {
        String keyPropertyName = this.getTranslatedTargetPropertyName(operation);
        JsonNode targetNode = target.get(keyPropertyName);
        if (JacksonUtils.isNotNull(targetNode)) {
            return targetNode;
        }
        return (JsonNode)CollUtil.getFirst(JacksonUtils.findNodes(target, operation.getTargetPropertyAliases()));
    }

    protected String getTranslatedTargetPropertyName(DisassembleOperation operation) {
        return JacksonUtils.translatePropertyName(this.objectMapper, operation.getTargetProperty().getName());
    }

    public JacksonDisassembler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

