/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.jackson.impl.handler.AbstractJacksonNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class ObjectNodeOperateHandler
extends AbstractJacksonNodeOperateHandler
implements OperateHandler {
    public ObjectNodeOperateHandler(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return Objects.nonNull(source) && ClassUtils.isAssignable(ObjectNode.class, source.getClass());
    }

    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return Objects.nonNull(target) && ClassUtils.isAssignable(ObjectNode.class, target.getClass());
    }

    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source) || !(source instanceof ObjectNode) || JacksonUtils.isNull((JsonNode)source)) {
            return NullNode.getInstance();
        }
        return property.hasResource() ? this.parse(source).get(this.translatePropertyName(property.getResource())) : source;
    }

    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (Objects.isNull(sourceData) || !(sourceData instanceof JsonNode) || JacksonUtils.isNull((JsonNode)target)) {
            return;
        }
        ObjectNode targetNode = this.parse(target);
        if (property.hasReference()) {
            String translatedReferenceName = this.translatePropertyName(property.getReference());
            this.parse(target).set(translatedReferenceName, (JsonNode)sourceData);
            return;
        }
        String nodeName = this.findNodeName((JsonNode)targetNode, operation.getTargetProperty().getName(), operation.getTargetPropertyAliases());
        if (CharSequenceUtil.isNotBlank((CharSequence)nodeName)) {
            targetNode.set(nodeName, (JsonNode)sourceData);
        }
    }

    private ObjectNode parse(Object target) {
        return (ObjectNode)target;
    }
}

