/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    private JacksonUtils() {
    }

    public static <T> T getBeanByPath(ObjectMapper objectMapper, T target, String jsonPath) {
        JsonNode targetNode = JacksonUtils.beanToTree(objectMapper, target).at(jsonPath);
        try {
            return (T)(targetNode.isNull() ? null : objectMapper.readValue(targetNode.textValue(), new TypeReference<T>(){}));
        }
        catch (JsonProcessingException e) {
            throw new CraneException((Throwable)e);
        }
    }

    public static JsonNode beanToTree(Object target) {
        return JacksonUtils.beanToTree(DEFAULT_MAPPER, target);
    }

    public static JsonNode beanToTree(ObjectMapper objectMapper, Object target) {
        return objectMapper.valueToTree(target);
    }

    public static String beanToJson(ObjectMapper objectMapper, Object target) {
        try {
            return objectMapper.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            throw new CraneException((Throwable)e);
        }
    }

    public static String beanToJson(Object target) {
        return JacksonUtils.beanToJson(DEFAULT_MAPPER, target);
    }

    public static <T> T jsonToBean(ObjectMapper objectMapper, String json, Class<T> target) {
        try {
            return (T)objectMapper.readValue(json, target);
        }
        catch (JsonProcessingException e) {
            throw new CraneException((Throwable)e);
        }
    }

    public static <T> T jsonToBean(String json, Class<T> target) {
        return JacksonUtils.jsonToBean(DEFAULT_MAPPER, json, target);
    }

    public static <T> List<T> jsonToList(ObjectMapper objectMapper, String json) {
        try {
            return (List)objectMapper.readValue(json, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CraneException((Throwable)e);
        }
    }

    public static <T> List<T> jsonToList(String json) {
        return JacksonUtils.jsonToList(DEFAULT_MAPPER, json);
    }

    public static String translatePropertyName(ObjectMapper objectMapper, String defName) {
        PropertyNamingStrategy namingStrategy = objectMapper.getPropertyNamingStrategy();
        return (String)ObjectUtils.computeIfNotNull((Object)namingStrategy, s -> s.nameForField((MapperConfig)objectMapper.getSerializationConfig(), null, defName), (Object)defName);
    }

    public static boolean isNotNull(JsonNode node) {
        return !JacksonUtils.isNull(node);
    }

    public static boolean isNull(JsonNode node) {
        return Objects.isNull(node) || node.isNull();
    }

    @NonNull
    public static List<JsonNode> findNodes(JsonNode source, Collection<String> nodeNames) {
        if (CollectionUtils.isEmpty(nodeNames)) {
            return Collections.emptyList();
        }
        return nodeNames.stream().filter(StringUtils::hasText).map(arg_0 -> ((JsonNode)source).get(arg_0)).filter(JacksonUtils::isNotNull).collect(Collectors.toList());
    }

    @Nullable
    public static JsonNode findNode(JsonNode source, String nodeName) {
        if (!StringUtils.hasText((String)nodeName)) {
            return null;
        }
        JsonNode node = source.get(nodeName);
        return Objects.isNull(node) || node.isNull() ? null : node;
    }
}

