/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.module;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class DynamicJsonNodeBeanSerializer<T>
extends StdSerializer<T> {
    private final ObjectMapper objectMapper;
    private final OperationConfiguration operationConfiguration;
    private final OperationExecutor operationExecutor;

    public DynamicJsonNodeBeanSerializer(Class<T> t, ObjectMapper objectMapper, OperationConfiguration operationConfiguration, OperationExecutor operationExecutor) {
        super(t);
        this.operationConfiguration = operationConfiguration;
        this.objectMapper = objectMapper;
        this.operationExecutor = operationExecutor;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (Objects.isNull(value)) {
            return;
        }
        JsonNode jsonNode = this.objectMapper.valueToTree(value);
        this.operationExecutor.execute((Iterable)CollUtils.adaptToCollection((Object)jsonNode), this.operationConfiguration);
        this.objectMapper.writeTree(gen, jsonNode);
    }
}

