/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.jackson.impl.handler.AbstractJacksonNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class ValueNodeOperateHandler
extends AbstractJacksonNodeOperateHandler
implements OperateHandler {
    public ValueNodeOperateHandler(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return Objects.nonNull(source) && ClassUtils.isAssignable(ValueNode.class, source.getClass());
    }

    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return Objects.nonNull(target) && ClassUtils.isAssignable(ValueNode.class, target.getClass());
    }

    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source) || !(source instanceof ValueNode) || JacksonUtils.isNull((JsonNode)((ValueNode)source))) {
            return NullNode.getInstance();
        }
        return source;
    }

    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
    }
}

