/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import cn.hutool.core.stream.StreamUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.jackson.impl.handler.AbstractJacksonNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class ArrayNodeOperateHandler
extends AbstractJacksonNodeOperateHandler
implements OperateHandler {
    private final OperateHandlerChain handlerChain;

    public ArrayNodeOperateHandler(ObjectMapper objectMapper, OperateHandlerChain assembleHandlerChain) {
        super(objectMapper);
        this.handlerChain = assembleHandlerChain;
    }

    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return Objects.nonNull(source) && ClassUtils.isAssignable(ArrayNode.class, source.getClass());
    }

    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return Objects.nonNull(target) && ClassUtils.isAssignable(ArrayNode.class, target.getClass());
    }

    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source) || !(source instanceof ArrayNode) || JacksonUtils.isNull((JsonNode)source)) {
            return NullNode.getInstance();
        }
        ArrayNode sourceNode = this.parse(source);
        if (!property.hasResource()) {
            return sourceNode;
        }
        ArrayNode arrayNode = this.objectMapper.getNodeFactory().arrayNode();
        StreamUtil.of((Iterable)sourceNode).map(t -> this.handlerChain.readFromSource(t, property, operation)).map(JsonNode.class::cast).filter(JacksonUtils::isNotNull).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }

    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (Objects.isNull(target) || !(target instanceof ArrayNode) || JacksonUtils.isNull((JsonNode)target)) {
            return;
        }
        for (JsonNode jsonNode : this.parse(target)) {
            this.handlerChain.writeToTarget(sourceData, (Object)jsonNode, property, operation);
        }
    }

    public ArrayNode parse(Object target) {
        return (ArrayNode)target;
    }
}

