/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.stream.StreamUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Collection;
import java.util.Objects;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;
import top.xiajibagao.crane.jackson.impl.handler.AbstractJacksonNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class ArrayNodeOperateHandler
extends AbstractJacksonNodeOperateHandler
implements OperateHandler {
    private final OperateHandlerChain handlerChain;

    public ArrayNodeOperateHandler(ObjectMapper objectMapper, OperateHandlerChain assembleHandlerChain) {
        super(objectMapper);
        this.handlerChain = assembleHandlerChain;
    }

    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return source instanceof ArrayNode || source instanceof Collection || Objects.nonNull(source) && source.getClass().isArray();
    }

    public JsonNode readFromSource(Object source, PropertyMapping property, Operation operation) {
        JsonNode sourceNode = JacksonUtils.valueToTree(source);
        if (sourceNode.isEmpty()) {
            return NullNode.getInstance();
        }
        Assert.isTrue((boolean)sourceNode.isArray(), (String)"\u503c[{}]\u4e0d\u662f\u6216\u65e0\u6cd5\u89e3\u6790\u4e3aJson\u6570\u7ec4", (Object[])new Object[]{source});
        if (!property.hasResource()) {
            return sourceNode;
        }
        ArrayNode arrayNode = this.objectMapper.getNodeFactory().arrayNode();
        StreamUtil.of((Iterable)sourceNode).map(node -> this.handlerChain.tryReadFromSource(node, property, operation)).map(JsonNode.class::cast).filter(JacksonUtils::isNotNull).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }

    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return target instanceof ArrayNode;
    }

    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        ArrayNode targetNode = (ArrayNode)target;
        if (targetNode.isEmpty()) {
            return;
        }
        targetNode.forEach(node -> this.handlerChain.tryWriteToTarget(sourceData, node, property, operation));
    }
}

